/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.dataflow;

import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerProvider;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LsmResource;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IStorageManager;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class LSMInvertedIndexLocalResource
extends LsmResource {
    private static final long serialVersionUID = 1L;
    private final ITypeTraits[] tokenTypeTraits;
    private final IBinaryComparatorFactory[] tokenCmpFactories;
    private final IBinaryTokenizerFactory tokenizerFactory;
    private final boolean isPartitioned;
    private final int[] invertedIndexFields;
    private final int[] filterFieldsForNonBulkLoadOps;
    private final int[] invertedIndexFieldsForNonBulkLoadOps;
    private final double bloomFilterFalsePositiveRate;

    public LSMInvertedIndexLocalResource(String path, IStorageManager storageManager, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] cmpFactories, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories, int[] filterFields, ILSMOperationTrackerFactory opTrackerProvider, ILSMIOOperationCallbackFactory ioOpCallbackFactory, IMetadataPageManagerFactory metadataPageManagerFactory, IVirtualBufferCacheProvider vbcProvider, ILSMIOOperationSchedulerProvider ioSchedulerProvider, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, boolean durable, ITypeTraits[] tokenTypeTraits, IBinaryComparatorFactory[] tokenCmpFactories, IBinaryTokenizerFactory tokenizerFactory, boolean isPartitioned, int[] invertedIndexFields, int[] filterFieldsForNonBulkLoadOps, int[] invertedIndexFieldsForNonBulkLoadOps, double bloomFilterFalsePositiveRate) {
        super(path, storageManager, typeTraits, cmpFactories, filterTypeTraits, filterCmpFactories, filterFields, opTrackerProvider, ioOpCallbackFactory, metadataPageManagerFactory, vbcProvider, ioSchedulerProvider, mergePolicyFactory, mergePolicyProperties, durable);
        this.tokenTypeTraits = tokenTypeTraits;
        this.tokenCmpFactories = tokenCmpFactories;
        this.tokenizerFactory = tokenizerFactory;
        this.isPartitioned = isPartitioned;
        this.invertedIndexFields = invertedIndexFields;
        this.filterFieldsForNonBulkLoadOps = filterFieldsForNonBulkLoadOps;
        this.invertedIndexFieldsForNonBulkLoadOps = invertedIndexFieldsForNonBulkLoadOps;
        this.bloomFilterFalsePositiveRate = bloomFilterFalsePositiveRate;
    }

    public ILSMIndex createInstance(INCServiceContext serviceCtx) throws HyracksDataException {
        IIOManager ioManager = serviceCtx.getIoManager();
        FileReference file = ioManager.resolve(this.path);
        List virtualBufferCaches = this.vbcProvider.getVirtualBufferCaches(serviceCtx, file);
        IBufferCache bufferCache = this.storageManager.getBufferCache(serviceCtx);
        ILSMMergePolicy mergePolicy = this.mergePolicyFactory.createMergePolicy(this.mergePolicyProperties, serviceCtx);
        ILSMIOOperationScheduler ioScheduler = this.ioSchedulerProvider.getIoScheduler(serviceCtx);
        this.ioOpCallbackFactory.initialize(serviceCtx, (IResource)this);
        if (this.isPartitioned) {
            return InvertedIndexUtils.createPartitionedLSMInvertedIndex(ioManager, virtualBufferCaches, this.typeTraits, this.cmpFactories, this.tokenTypeTraits, this.tokenCmpFactories, this.tokenizerFactory, bufferCache, file.getAbsolutePath(), this.bloomFilterFalsePositiveRate, mergePolicy, this.opTrackerProvider.getOperationTracker(serviceCtx, (IResource)this), ioScheduler, this.ioOpCallbackFactory, this.invertedIndexFields, this.filterTypeTraits, this.filterCmpFactories, this.filterFields, this.filterFieldsForNonBulkLoadOps, this.invertedIndexFieldsForNonBulkLoadOps, this.durable, (IPageManagerFactory)this.metadataPageManagerFactory);
        }
        return InvertedIndexUtils.createLSMInvertedIndex(ioManager, virtualBufferCaches, this.typeTraits, this.cmpFactories, this.tokenTypeTraits, this.tokenCmpFactories, this.tokenizerFactory, bufferCache, file.getAbsolutePath(), this.bloomFilterFalsePositiveRate, mergePolicy, this.opTrackerProvider.getOperationTracker(serviceCtx, (IResource)this), ioScheduler, this.ioOpCallbackFactory, this.invertedIndexFields, this.filterTypeTraits, this.filterCmpFactories, this.filterFields, this.filterFieldsForNonBulkLoadOps, this.invertedIndexFieldsForNonBulkLoadOps, this.durable, this.metadataPageManagerFactory);
    }
}

