/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.asterix.lang.common.statement;

import java.util.List;

public class InternalDetailsDecl implements IDatasetDetailsDecl {
    private final List<List<String>> partitioningExprs;
    private final List<Integer> keySourceIndicators;
    private final boolean autogenerated;
    private final List<String> filterField;

    public InternalDetailsDecl(List<List<String>> partitioningExpr, List<Integer> keySourceIndicators,
            boolean autogenerated, List<String> filterField) {
        this.partitioningExprs = partitioningExpr;
        this.keySourceIndicators = keySourceIndicators;
        this.autogenerated = autogenerated;
        this.filterField = filterField;
    }

    public List<List<String>> getPartitioningExprs() {
        return partitioningExprs;
    }

    public List<Integer> getKeySourceIndicators() {
        return keySourceIndicators;
    }

    public boolean isAutogenerated() {
        return autogenerated;
    }

    public List<String> getFilterField() {
        return filterField;
    }

}
