/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.net.protocols.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.hyracks.net.protocols.tcp.ITCPConnectionEventListener;
import org.apache.hyracks.net.protocols.tcp.TCPEndpoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TCPConnection {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TCPEndpoint endpoint;
    private final SocketChannel channel;
    private final InetSocketAddress remoteAddress;
    private final SelectionKey key;
    private final Selector selector;
    private ITCPConnectionEventListener eventListener;
    private Object attachment;
    private ConnectionType type;

    public TCPConnection(TCPEndpoint endpoint, SocketChannel channel, SelectionKey key, Selector selector, ConnectionType type) {
        this.endpoint = endpoint;
        this.channel = channel;
        this.key = key;
        this.selector = selector;
        this.type = type;
        this.remoteAddress = (InetSocketAddress)channel.socket().getRemoteSocketAddress();
    }

    public TCPEndpoint getEndpoint() {
        return this.endpoint;
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.socket().getLocalSocketAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void enable(int ops) {
        this.key.interestOps(this.key.interestOps() | ops);
        this.selector.wakeup();
    }

    public void disable(int ops) {
        this.key.interestOps(this.key.interestOps() & ~ops);
        this.selector.wakeup();
    }

    public ITCPConnectionEventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(ITCPConnectionEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public synchronized void close() {
        this.key.cancel();
        try {
            this.channel.close();
        }
        catch (IOException e) {
            LOGGER.error(() -> "Error closing channel at: " + this.remoteAddress, (Throwable)e);
        }
    }

    public ConnectionType getType() {
        return this.type;
    }

    public String toString() {
        return "TCPConnection[Remote Address: " + this.remoteAddress + " Local Address: " + this.endpoint.getLocalAddress() + "]";
    }

    public static enum ConnectionType {
        INCOMING,
        OUTGOING;

    }
}

