/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.meta;

import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.EnforcePushRuntime;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntime;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.EnforceFrameWriter;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobFlag;

public class PipelineAssembler {
    private final RecordDescriptor pipelineInputRecordDescriptor;
    private final RecordDescriptor pipelineOutputRecordDescriptor;
    private final int inputArity;
    private final int outputArity;
    private final AlgebricksPipeline pipeline;
    private final Map<IPushRuntimeFactory, IPushRuntime[]> runtimeMap;

    public PipelineAssembler(AlgebricksPipeline pipeline, int inputArity, int outputArity, RecordDescriptor pipelineInputRecordDescriptor, RecordDescriptor pipelineOutputRecordDescriptor) {
        this.pipeline = pipeline;
        this.pipelineInputRecordDescriptor = pipelineInputRecordDescriptor;
        this.pipelineOutputRecordDescriptor = pipelineOutputRecordDescriptor;
        this.inputArity = inputArity;
        this.outputArity = outputArity;
        this.runtimeMap = new HashMap<IPushRuntimeFactory, IPushRuntime[]>();
    }

    public IFrameWriter assemblePipeline(IFrameWriter writer, IHyracksTaskContext ctx) throws HyracksDataException {
        boolean enforce = ctx.getJobFlags().contains(JobFlag.ENFORCE_CONTRACT);
        IFrameWriter start = writer;
        IPushRuntimeFactory[] runtimeFactories = this.pipeline.getRuntimeFactories();
        RecordDescriptor[] recordDescriptors = this.pipeline.getRecordDescriptors();
        for (int i = runtimeFactories.length - 1; i >= 0; --i) {
            start = enforce ? EnforceFrameWriter.enforce((IFrameWriter)start) : start;
            IPushRuntimeFactory runtimeFactory = runtimeFactories[i];
            IPushRuntime[] newRuntimes = runtimeFactory.createPushRuntime(ctx);
            for (int j = 0; j < newRuntimes.length; ++j) {
                if (enforce) {
                    newRuntimes[j] = EnforcePushRuntime.enforce(newRuntimes[j]);
                }
                if (i == runtimeFactories.length - 1) {
                    if (this.outputArity != 1) continue;
                    newRuntimes[j].setOutputFrameWriter(0, start, this.pipelineOutputRecordDescriptor);
                    continue;
                }
                newRuntimes[j].setOutputFrameWriter(0, start, recordDescriptors[i]);
            }
            this.runtimeMap.put(runtimeFactory, newRuntimes);
            IPushRuntime newRuntime = newRuntimes[0];
            if (i > 0) {
                newRuntime.setInputRecordDescriptor(0, recordDescriptors[i - 1]);
            } else if (this.inputArity > 0) {
                newRuntime.setInputRecordDescriptor(0, this.pipelineInputRecordDescriptor);
            }
            start = newRuntime;
        }
        return start;
    }

    public IPushRuntime[] getPushRuntime(IPushRuntimeFactory runtimeFactory) {
        return this.runtimeMap.get(runtimeFactory);
    }
}

