/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.CheckDatasetOnlyResolutionVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class VariableCheckAndRewriteVisitor
extends AbstractSqlppExpressionScopingVisitor {
    private static final FunctionSignature FN_DATASET = new FunctionSignature(BuiltinFunctions.DATASET);
    protected final MetadataProvider metadataProvider;

    public VariableCheckAndRewriteVisitor(LangRewritingContext context, MetadataProvider metadataProvider, Collection<VarIdentifier> externalVars) {
        super(context, externalVars);
        this.metadataProvider = metadataProvider;
    }

    @Override
    public Expression visit(FieldAccessor fa, ILangExpression parent) throws CompilationException {
        CallExpr callExpr;
        Expression leadingExpr = fa.getExpr();
        if (leadingExpr.getKind() != Expression.Kind.VARIABLE_EXPRESSION) {
            fa.setExpr((Expression)leadingExpr.accept((ILangVisitor)this, (Object)fa));
            return fa;
        }
        VariableExpr varExpr = (VariableExpr)leadingExpr;
        String lastIdentifier = fa.getIdent().getValue();
        Expression resolvedExpr = this.resolve(varExpr, SqlppVariableUtil.toUserDefinedVariableName(varExpr.getVar().getValue()).getValue(), lastIdentifier, (Expression)fa, parent);
        if (resolvedExpr.getKind() == Expression.Kind.CALL_EXPRESSION && (callExpr = (CallExpr)resolvedExpr).getFunctionSignature().equals((Object)FN_DATASET)) {
            return resolvedExpr;
        }
        fa.setExpr(resolvedExpr);
        return fa;
    }

    @Override
    public Expression visit(VariableExpr varExpr, ILangExpression parent) throws CompilationException {
        return this.resolve(varExpr, this.metadataProvider.getDefaultDataverseName(), SqlppVariableUtil.toUserDefinedVariableName(varExpr.getVar().getValue()).getValue(), (Expression)varExpr, parent);
    }

    private Expression resolve(VariableExpr varExpr, String dataverseName, String datasetName, Expression originalExprWithUndefinedIdentifier, ILangExpression parent) throws CompilationException {
        SourceLocation sourceLoc;
        VarIdentifier varId = varExpr.getVar();
        String varName = varId.getValue();
        VarIdentifier var = this.lookupVariable(varName, sourceLoc = varExpr.getSourceLocation());
        if (var != null) {
            varExpr.setIsNewVar(false);
            varExpr.setVar(var);
            return varExpr;
        }
        if (SqlppVariableUtil.isExternalVariableIdentifier(varId)) {
            throw new CompilationException(1086, sourceLoc, new Serializable[]{SqlppVariableUtil.variableNameToDisplayedFieldName(varId.getValue())});
        }
        boolean resolveToDatasetOnly = this.resolveToDatasetOnly(originalExprWithUndefinedIdentifier, parent);
        if (resolveToDatasetOnly) {
            return this.resolveAsDataset(dataverseName, datasetName, sourceLoc);
        }
        Set localVars = this.scopeChecker.getCurrentScope().getLiveVariables(this.scopeChecker.getPrecedingScope(), arg_0 -> ((LangRewritingContext)this.context).isExcludedForFieldAccessVar(arg_0));
        switch (localVars.size()) {
            case 0: {
                return this.resolveAsDataset(dataverseName, datasetName, sourceLoc);
            }
            case 1: {
                return this.resolveAsFieldAccess((VariableExpr)localVars.iterator().next(), SqlppVariableUtil.toUserDefinedVariableName(varName).getValue(), sourceLoc);
            }
        }
        throw new CompilationException(1074, sourceLoc, new Serializable[]{SqlppVariableUtil.toUserDefinedVariableName(varName).getValue()});
    }

    private VarIdentifier lookupVariable(String varName, SourceLocation sourceLoc) throws CompilationException {
        if (this.scopeChecker.isInForbiddenScopes(varName)) {
            throw new CompilationException(1075, sourceLoc, new Serializable[0]);
        }
        Identifier ident = this.scopeChecker.lookupSymbol(varName);
        return ident != null ? (VarIdentifier)ident : null;
    }

    private Expression resolveAsDataset(String dataverseName, String datasetName, SourceLocation sourceLoc) throws CompilationException {
        if (!this.datasetExists(dataverseName, datasetName, sourceLoc)) {
            this.throwUnresolvableError(dataverseName, datasetName, sourceLoc);
        }
        String fullyQualifiedName = dataverseName == null ? datasetName : dataverseName + "." + datasetName;
        ArrayList<LiteralExpr> argList = new ArrayList<LiteralExpr>(1);
        argList.add(new LiteralExpr((Literal)new StringLiteral(fullyQualifiedName)));
        CallExpr callExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.DATASET), argList);
        callExpr.setSourceLocation(sourceLoc);
        return callExpr;
    }

    private Expression resolveAsFieldAccess(VariableExpr var, String fieldName, SourceLocation sourceLoc) {
        ArrayList<Object> argList = new ArrayList<Object>(2);
        argList.add(var);
        argList.add(new LiteralExpr((Literal)new StringLiteral(fieldName)));
        CallExpr callExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.FIELD_ACCESS_BY_NAME), argList);
        callExpr.setSourceLocation(sourceLoc);
        return callExpr;
    }

    private void throwUnresolvableError(String dataverseName, String datasetName, SourceLocation sourceLoc) throws CompilationException {
        String defaultDataverseName = this.metadataProvider.getDefaultDataverseName();
        if (dataverseName == null && defaultDataverseName == null) {
            throw new CompilationException(1076, sourceLoc, new Serializable[]{datasetName});
        }
        throw new CompilationException(1077, sourceLoc, new Serializable[]{datasetName, dataverseName == null ? defaultDataverseName : dataverseName});
    }

    private boolean resolveToDatasetOnly(Expression originalExpressionWithUndefinedIdentifier, ILangExpression parent) throws CompilationException {
        CheckDatasetOnlyResolutionVisitor visitor = new CheckDatasetOnlyResolutionVisitor();
        return (Boolean)parent.accept((ILangVisitor)visitor, (Object)originalExpressionWithUndefinedIdentifier);
    }

    private boolean datasetExists(String dataverseName, String datasetName, SourceLocation sourceLoc) throws CompilationException {
        try {
            return this.metadataProvider.findDataset(dataverseName, datasetName) != null || this.fullyQualifiedDatasetNameExists(datasetName);
        }
        catch (AlgebricksException e) {
            throw new CompilationException(1079, (Throwable)e, sourceLoc, new Serializable[]{e.getMessage()});
        }
    }

    private boolean fullyQualifiedDatasetNameExists(String name) throws AlgebricksException {
        if (name.indexOf(46) < 0) {
            return false;
        }
        String[] path = StringUtils.split((String)name, (char)'.');
        return path.length == 2 && this.metadataProvider.findDataset(path[0], path[1]) != null;
    }

    @Override
    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        if (FunctionMapUtil.isSql92AggregateFunction(callExpr.getFunctionSignature())) {
            return callExpr;
        }
        return super.visit(callExpr, arg);
    }
}

