/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.CheckSql92AggregateVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppSimpleExpressionVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class SqlppGroupByVisitor
extends AbstractSqlppSimpleExpressionVisitor {
    private final LangRewritingContext context;

    public SqlppGroupByVisitor(LangRewritingContext context) {
        this.context = context;
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        if (selectBlock.hasFromClause()) {
            if (selectBlock.hasGroupbyClause()) {
                this.rewriteSelectWithGroupBy(selectBlock, arg);
            } else {
                this.rewriteSelectWithoutGroupBy(selectBlock);
            }
        }
        return super.visit(selectBlock, arg);
    }

    private void rewriteSelectWithGroupBy(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        List<Object> groupFieldList;
        GroupbyClause gbyClause = selectBlock.getGroupbyClause();
        if (!gbyClause.hasGroupVar()) {
            VariableExpr groupVar = new VariableExpr(this.context.newVariable());
            groupVar.setSourceLocation(gbyClause.getSourceLocation());
            gbyClause.setGroupVar(groupVar);
        }
        if (gbyClause.hasGroupFieldList()) {
            groupFieldList = new ArrayList();
            for (Pair groupField : gbyClause.getGroupFieldList()) {
                Expression newFieldExpr = (Expression)((Expression)groupField.first).accept((ILangVisitor)this, (Object)arg);
                groupFieldList.add(new Pair((Object)newFieldExpr, groupField.second));
            }
        } else {
            groupFieldList = this.createGroupFieldList(selectBlock);
        }
        gbyClause.setGroupFieldList(groupFieldList);
    }

    private void rewriteSelectWithoutGroupBy(SelectBlock selectBlock) throws CompilationException {
        if (this.hasSql92Aggregate(selectBlock)) {
            ArrayList gbyPairList = new ArrayList();
            ArrayList decorPairList = new ArrayList();
            VariableExpr groupVar = new VariableExpr(this.context.newVariable());
            groupVar.setSourceLocation(selectBlock.getSourceLocation());
            List<Pair<Expression, Identifier>> groupFieldList = this.createGroupFieldList(selectBlock);
            GroupbyClause gbyClause = new GroupbyClause(gbyPairList, decorPairList, new HashMap(), groupVar, groupFieldList, false, true);
            gbyClause.setSourceLocation(selectBlock.getSourceLocation());
            selectBlock.setGroupbyClause(gbyClause);
        }
    }

    private boolean hasSql92Aggregate(SelectBlock selectBlock) throws CompilationException {
        SelectClause selectClause = selectBlock.getSelectClause();
        if (selectClause.selectRegular()) {
            return this.isSql92Aggregate((ILangExpression)selectClause.getSelectRegular(), selectBlock);
        }
        if (selectClause.selectElement()) {
            return this.isSql92Aggregate((ILangExpression)selectClause.getSelectElement(), selectBlock);
        }
        throw new IllegalStateException();
    }

    private boolean isSql92Aggregate(ILangExpression expr, SelectBlock selectBlock) throws CompilationException {
        CheckSql92AggregateVisitor visitor = new CheckSql92AggregateVisitor();
        return (Boolean)expr.accept((ILangVisitor)visitor, (Object)selectBlock);
    }

    private List<Pair<Expression, Identifier>> createGroupFieldList(SelectBlock selectBlock) {
        ArrayList<Pair<Expression, Identifier>> groupFieldList = new ArrayList<Pair<Expression, Identifier>>();
        this.addToGroupFieldList(groupFieldList, SqlppVariableUtil.getBindingVariables(selectBlock.getFromClause()));
        this.addToGroupFieldList(groupFieldList, SqlppVariableUtil.getBindingVariables(selectBlock.getLetList()));
        return groupFieldList;
    }

    private void addToGroupFieldList(List<Pair<Expression, Identifier>> groupFieldList, Collection<VariableExpr> fromBindingVars) {
        for (VariableExpr varExpr : fromBindingVars) {
            VariableExpr newVarExpr = new VariableExpr(varExpr.getVar());
            newVarExpr.setSourceLocation(varExpr.getSourceLocation());
            Pair varIdPair = new Pair((Object)newVarExpr, (Object)SqlppVariableUtil.toUserDefinedVariableName(varExpr.getVar()));
            groupFieldList.add((Pair<Expression, Identifier>)varIdPair);
        }
    }
}

