/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SetOperationVisitor
extends AbstractSqlppExpressionScopingVisitor {
    public SetOperationVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(SelectExpression selectExpression, ILangExpression arg) throws CompilationException {
        SelectSetOperation selectSetOperation = selectExpression.getSelectSetOperation();
        if (!selectSetOperation.hasRightInputs() || !selectExpression.hasOrderby() && !selectExpression.hasLimit()) {
            return super.visit(selectExpression, arg);
        }
        OrderbyClause orderBy = selectExpression.getOrderbyClause();
        LimitClause limit = selectExpression.getLimitClause();
        SourceLocation sourceLoc = selectExpression.getSourceLocation();
        SelectExpression nestedSelectExpression = new SelectExpression(null, selectSetOperation, null, null, true);
        nestedSelectExpression.setSourceLocation(sourceLoc);
        VariableExpr newBindingVar = new VariableExpr(this.context.newVariable());
        newBindingVar.setSourceLocation(sourceLoc);
        FromTerm newFromTerm = new FromTerm((Expression)nestedSelectExpression, newBindingVar, null, null);
        newFromTerm.setSourceLocation(sourceLoc);
        FromClause newFromClause = new FromClause(new ArrayList<FromTerm>(Collections.singletonList(newFromTerm)));
        newFromClause.setSourceLocation(sourceLoc);
        SelectClause selectClause = new SelectClause(new SelectElement((Expression)newBindingVar), null, false);
        selectClause.setSourceLocation(sourceLoc);
        SelectBlock selectBlock = new SelectBlock(selectClause, newFromClause, null, null, null, null, null);
        selectBlock.setSourceLocation(sourceLoc);
        SelectSetOperation newSelectSetOperation = new SelectSetOperation(new SetOperationInput(selectBlock, null), null);
        newSelectSetOperation.setSourceLocation(sourceLoc);
        SelectExpression newSelectExpression = new SelectExpression(selectExpression.getLetList(), newSelectSetOperation, orderBy, limit, selectExpression.isSubquery());
        newSelectExpression.setSourceLocation(sourceLoc);
        return super.visit(newSelectExpression, arg);
    }
}

