/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class OperatorExpressionVisitor
extends AbstractSqlppExpressionScopingVisitor {
    public OperatorExpressionVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(OperatorExpr operatorExpr, ILangExpression arg) throws CompilationException {
        ArrayList<Object> newExprList = new ArrayList<Object>();
        for (Expression expr : operatorExpr.getExprList()) {
            newExprList.add(expr.accept((ILangVisitor)this, (Object)operatorExpr));
        }
        operatorExpr.setExprList(newExprList);
        OperatorType opType = (OperatorType)operatorExpr.getOpList().get(0);
        switch (opType) {
            case LIKE: 
            case NOT_LIKE: {
                return this.processLikeOperator(operatorExpr, opType);
            }
            case IN: 
            case NOT_IN: {
                return this.processInOperator(operatorExpr, opType);
            }
            case CONCAT: {
                return this.processConcatOperator(operatorExpr);
            }
            case BETWEEN: 
            case NOT_BETWEEN: {
                return this.processBetweenOperator(operatorExpr, opType);
            }
        }
        return operatorExpr;
    }

    private Expression processLikeOperator(OperatorExpr operatorExpr, OperatorType opType) {
        CallExpr likeExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.STRING_LIKE), operatorExpr.getExprList());
        likeExpr.setSourceLocation(operatorExpr.getSourceLocation());
        switch (opType) {
            case LIKE: {
                return likeExpr;
            }
            case NOT_LIKE: {
                CallExpr notLikeExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.NOT), new ArrayList<CallExpr>(Collections.singletonList(likeExpr)));
                notLikeExpr.setSourceLocation(operatorExpr.getSourceLocation());
                return notLikeExpr;
            }
        }
        throw new IllegalArgumentException(String.valueOf(opType));
    }

    private Expression processInOperator(OperatorExpr operatorExpr, OperatorType opType) throws CompilationException {
        VariableExpr bindingVar = new VariableExpr(this.context.newVariable());
        bindingVar.setSourceLocation(operatorExpr.getSourceLocation());
        Expression itemExpr = (Expression)operatorExpr.getExprList().get(0);
        Expression collectionExpr = (Expression)operatorExpr.getExprList().get(1);
        OperatorExpr comparison = new OperatorExpr();
        comparison.addOperand(itemExpr);
        comparison.addOperand((Expression)bindingVar);
        comparison.setCurrentop(true);
        comparison.setSourceLocation(operatorExpr.getSourceLocation());
        if (opType == OperatorType.IN) {
            comparison.addOperator(OperatorType.EQ);
            QuantifiedExpression quantExpr = new QuantifiedExpression(QuantifiedExpression.Quantifier.SOME, new ArrayList<QuantifiedPair>(Collections.singletonList(new QuantifiedPair(bindingVar, collectionExpr))), (Expression)comparison);
            quantExpr.setSourceLocation(operatorExpr.getSourceLocation());
            return quantExpr;
        }
        comparison.addOperator(OperatorType.NEQ);
        QuantifiedExpression quantExpr = new QuantifiedExpression(QuantifiedExpression.Quantifier.EVERY, new ArrayList<QuantifiedPair>(Collections.singletonList(new QuantifiedPair(bindingVar, collectionExpr))), (Expression)comparison);
        quantExpr.setSourceLocation(operatorExpr.getSourceLocation());
        return quantExpr;
    }

    private Expression processConcatOperator(OperatorExpr operatorExpr) {
        CallExpr callExpr = new CallExpr(new FunctionSignature("asterix", "concat", 1), operatorExpr.getExprList());
        callExpr.setSourceLocation(operatorExpr.getSourceLocation());
        return callExpr;
    }

    private Expression processBetweenOperator(OperatorExpr operatorExpr, OperatorType opType) throws CompilationException {
        Expression target = (Expression)operatorExpr.getExprList().get(0);
        Expression left = (Expression)operatorExpr.getExprList().get(1);
        Expression right = (Expression)operatorExpr.getExprList().get(2);
        Expression leftComparison = this.createOperatorExpression(OperatorType.GE, target, left, operatorExpr.getHints(), operatorExpr.getSourceLocation());
        Expression targetCopy = (Expression)SqlppRewriteUtil.deepCopy((ILangExpression)target);
        Expression rightComparison = this.createOperatorExpression(OperatorType.LE, targetCopy, right, operatorExpr.getHints(), operatorExpr.getSourceLocation());
        OperatorExpr andExpr = new OperatorExpr();
        andExpr.addOperand(leftComparison);
        andExpr.addOperand(rightComparison);
        andExpr.addOperator(OperatorType.AND);
        andExpr.setSourceLocation(operatorExpr.getSourceLocation());
        if (opType == OperatorType.BETWEEN) {
            return andExpr;
        }
        CallExpr callExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.NOT), new ArrayList<OperatorExpr>(Collections.singletonList(andExpr)));
        callExpr.setSourceLocation(operatorExpr.getSourceLocation());
        return callExpr;
    }

    private Expression createOperatorExpression(OperatorType opType, Expression lhs, Expression rhs, List<IExpressionAnnotation> hints, SourceLocation sourceLoc) {
        OperatorExpr comparison = new OperatorExpr();
        comparison.addOperand(lhs);
        comparison.addOperand(rhs);
        comparison.addOperator(opType);
        comparison.setSourceLocation(sourceLoc);
        if (hints != null) {
            for (IExpressionAnnotation hint : hints) {
                comparison.addHint(hint);
            }
        }
        return comparison;
    }
}

