/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.clause;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;

public class SelectBlock
extends AbstractClause {
    private SelectClause selectClause;
    private FromClause fromClause;
    private List<LetClause> letClauses = new ArrayList<LetClause>();
    private WhereClause whereClause;
    private GroupbyClause groupbyClause;
    private List<LetClause> letClausesAfterGby = new ArrayList<LetClause>();
    private HavingClause havingClause;

    public SelectBlock(SelectClause selectClause, FromClause fromClause, List<LetClause> letClauses, WhereClause whereClause, GroupbyClause groupbyClause, List<LetClause> letClausesAfterGby, HavingClause havingClause) {
        this.selectClause = selectClause;
        this.fromClause = fromClause;
        if (letClauses != null) {
            this.letClauses.addAll(letClauses);
        }
        this.whereClause = whereClause;
        this.groupbyClause = groupbyClause;
        this.havingClause = havingClause;
        if (letClausesAfterGby != null) {
            this.letClausesAfterGby.addAll(letClausesAfterGby);
        }
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.SELECT_BLOCK;
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public List<LetClause> getLetList() {
        return this.letClauses;
    }

    public WhereClause getWhereClause() {
        return this.whereClause;
    }

    public GroupbyClause getGroupbyClause() {
        return this.groupbyClause;
    }

    public HavingClause getHavingClause() {
        return this.havingClause;
    }

    public boolean hasFromClause() {
        return this.fromClause != null;
    }

    public boolean hasLetClauses() {
        return !this.letClauses.isEmpty();
    }

    public boolean hasWhereClause() {
        return this.whereClause != null;
    }

    public boolean hasGroupbyClause() {
        return this.groupbyClause != null;
    }

    public boolean hasLetClausesAfterGroupby() {
        return !this.letClausesAfterGby.isEmpty();
    }

    public List<LetClause> getLetListAfterGroupby() {
        return this.letClausesAfterGby;
    }

    public boolean hasHavingClause() {
        return this.havingClause != null;
    }

    public void setGroupbyClause(GroupbyClause groupbyClause) {
        this.groupbyClause = groupbyClause;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fromClause, this.groupbyClause, this.havingClause, this.letClauses, this.letClausesAfterGby, this.selectClause, this.whereClause});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SelectBlock)) {
            return false;
        }
        SelectBlock target = (SelectBlock)((Object)object);
        return Objects.equals((Object)this.fromClause, (Object)target.fromClause) && Objects.equals(this.groupbyClause, target.groupbyClause) && Objects.equals((Object)this.havingClause, (Object)target.havingClause) && Objects.equals(this.letClauses, target.letClauses) && Objects.equals(this.letClausesAfterGby, target.letClausesAfterGby) && Objects.equals((Object)this.selectClause, (Object)target.selectClause) && Objects.equals(this.whereClause, target.whereClause);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.selectClause);
        if (this.hasFromClause()) {
            sb.append(" " + (Object)((Object)this.fromClause));
        }
        if (this.hasLetClauses()) {
            sb.append(" " + this.letClauses);
        }
        if (this.hasWhereClause()) {
            sb.append(" " + this.whereClause);
        }
        if (this.hasGroupbyClause()) {
            sb.append(" " + this.groupbyClause);
        }
        if (this.hasLetClausesAfterGroupby()) {
            sb.append(" " + this.letClausesAfterGby);
        }
        if (this.hasHavingClause()) {
            sb.append(" " + (Object)((Object)this.havingClause));
        }
        return sb.toString();
    }
}

