/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.algebra.base.ILangExpressionToPlanTranslator;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.optype.JoinType;
import org.apache.asterix.lang.sqlpp.optype.SetOpType;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACollection;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.translator.ConstantHelper;
import org.apache.asterix.translator.LangExpressionToPlanTranslator;
import org.apache.asterix.translator.PositionWriter;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestNonMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingPositionWriter;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SqlppExpressionToPlanTranslator
extends LangExpressionToPlanTranslator
implements ILangExpressionToPlanTranslator,
ISqlppVisitor<Pair<ILogicalOperator, LogicalVariable>, Mutable<ILogicalOperator>> {
    private static final String ERR_MSG = "Translator should never enter this method!";
    public static final String REWRITE_IN_AS_OR_OPTION = "rewrite_in_as_or";
    private static final boolean REWRITE_IN_AS_OR_OPTION_DEFAULT = true;
    private Deque<Mutable<ILogicalOperator>> uncorrelatedLeftBranchStack = new ArrayDeque<Mutable<ILogicalOperator>>();
    private final Map<VarIdentifier, IAObject> externalVars;
    private final boolean translateInAsOr;

    public SqlppExpressionToPlanTranslator(MetadataProvider metadataProvider, int currentVarCounter, Map<VarIdentifier, IAObject> externalVars) throws AlgebricksException {
        super(metadataProvider, currentVarCounter);
        this.externalVars = externalVars != null ? externalVars : Collections.emptyMap();
        this.translateInAsOr = metadataProvider.getBooleanProperty(REWRITE_IN_AS_OR_OPTION, true);
    }

    @Override
    public Pair<ILogicalOperator, LogicalVariable> visit(Query q, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Expression queryBody = q.getBody();
        SourceLocation sourceLoc = queryBody.getSourceLocation();
        if (queryBody.getKind() == Expression.Kind.SELECT_EXPRESSION) {
            SelectExpression selectExpr = (SelectExpression)queryBody;
            if (q.isTopLevel()) {
                selectExpr.setSubquery(false);
            }
            return (Pair)queryBody.accept((ILangVisitor)this, tupSource);
        }
        LogicalVariable var = this.context.newVar();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(queryBody, tupSource);
        AssignOperator assignOp = new AssignOperator(var, (Mutable)new MutableObject(eo.first));
        assignOp.getInputs().add(eo.second);
        assignOp.setSourceLocation(sourceLoc);
        ProjectOperator projectOp = new ProjectOperator(var);
        projectOp.getInputs().add(new MutableObject((Object)assignOp));
        projectOp.setSourceLocation(sourceLoc);
        return new Pair((Object)projectOp, (Object)var);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectExpression selectExpression, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        if (selectExpression.isSubquery()) {
            this.context.enterSubplan();
        }
        MutableObject currentOpRef = tupSource;
        if (selectExpression.hasLetClauses()) {
            for (LetClause letClause : selectExpression.getLetList()) {
                currentOpRef = new MutableObject(((Pair)letClause.accept((ILangVisitor)this, (Object)currentOpRef)).first);
            }
        }
        Pair select = (Pair)selectExpression.getSelectSetOperation().accept((ILangVisitor)this, currentOpRef);
        currentOpRef = new MutableObject(select.first);
        if (selectExpression.hasOrderby()) {
            currentOpRef = new MutableObject(((Pair)selectExpression.getOrderbyClause().accept((ILangVisitor)this, (Object)currentOpRef)).first);
        }
        if (selectExpression.hasLimit()) {
            currentOpRef = new MutableObject(((Pair)selectExpression.getLimitClause().accept((ILangVisitor)this, (Object)currentOpRef)).first);
        }
        Pair<ILogicalOperator, LogicalVariable> result = this.produceSelectPlan(selectExpression.isSubquery(), (Mutable<ILogicalOperator>)currentOpRef, (LogicalVariable)select.second);
        if (selectExpression.isSubquery()) {
            this.context.exitSubplan();
        }
        return result;
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectSetOperation selectSetOperation, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        SelectExpression leftInputExpr;
        SetOperationInput leftInput = selectSetOperation.getLeftInput();
        if (!selectSetOperation.hasRightInputs()) {
            return (Pair)leftInput.accept((ILangVisitor)this, tupSource);
        }
        ArrayList<ILangExpression> inputExprs = new ArrayList<ILangExpression>();
        if (leftInput.selectBlock()) {
            leftInputExpr = new SelectExpression(null, new SelectSetOperation(leftInput, null), null, null, true);
            leftInputExpr.setSourceLocation(leftInput.getSelectBlock().getSourceLocation());
        } else {
            leftInputExpr = leftInput.getSubquery();
        }
        inputExprs.add((ILangExpression)leftInputExpr);
        for (SetOperationRight setOperationRight : selectSetOperation.getRightInputs()) {
            SelectExpression rightInputExpr;
            SetOpType setOpType = setOperationRight.getSetOpType();
            if (setOpType != SetOpType.UNION || setOperationRight.isSetSemantics()) {
                throw new CompilationException(1079, selectSetOperation.getSourceLocation(), new Serializable[]{"Operation " + setOpType + (setOperationRight.isSetSemantics() ? " with set semantics" : "ALL") + " is not supported."});
            }
            SetOperationInput rightInput = setOperationRight.getSetOperationRightInput();
            if (rightInput.selectBlock()) {
                rightInputExpr = new SelectExpression(null, new SelectSetOperation(rightInput, null), null, null, true);
                rightInputExpr.setSourceLocation(rightInput.getSelectBlock().getSourceLocation());
            } else {
                rightInputExpr = rightInput.getSubquery();
            }
            inputExprs.add((ILangExpression)rightInputExpr);
        }
        return this.translateUnionAllFromInputExprs(inputExprs, tupSource, selectSetOperation.getSourceLocation());
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectBlock selectBlock, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        MutableObject currentOpRef = tupSource;
        if (selectBlock.hasFromClause()) {
            currentOpRef = new MutableObject(((Pair)selectBlock.getFromClause().accept((ILangVisitor)this, currentOpRef)).first);
        }
        if (selectBlock.hasLetClauses()) {
            for (LetClause letClause : selectBlock.getLetList()) {
                currentOpRef = new MutableObject(((Pair)letClause.accept((ILangVisitor)this, (Object)currentOpRef)).first);
            }
        }
        if (selectBlock.hasWhereClause()) {
            currentOpRef = new MutableObject(((Pair)selectBlock.getWhereClause().accept((ILangVisitor)this, (Object)currentOpRef)).first);
        }
        if (selectBlock.hasGroupbyClause()) {
            currentOpRef = new MutableObject(((Pair)selectBlock.getGroupbyClause().accept((ILangVisitor)this, (Object)currentOpRef)).first);
        }
        if (selectBlock.hasLetClausesAfterGroupby()) {
            for (LetClause letClause : selectBlock.getLetListAfterGroupby()) {
                currentOpRef = new MutableObject(((Pair)letClause.accept((ILangVisitor)this, (Object)currentOpRef)).first);
            }
        }
        if (selectBlock.hasHavingClause()) {
            currentOpRef = new MutableObject(((Pair)selectBlock.getHavingClause().accept((ILangVisitor)this, (Object)currentOpRef)).first);
        }
        return this.processSelectClause(selectBlock, (Mutable<ILogicalOperator>)currentOpRef);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(FromClause fromClause, Mutable<ILogicalOperator> arg) throws CompilationException {
        MutableObject inputSrc = arg;
        Pair topUnnest = null;
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            topUnnest = (Pair)fromTerm.accept((ILangVisitor)this, inputSrc);
            inputSrc = new MutableObject(topUnnest.first);
        }
        return topUnnest;
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(FromTerm fromTerm, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        UnnestOperator unnestOp;
        SourceLocation sourceLoc = fromTerm.getSourceLocation();
        LogicalVariable fromVar = this.context.newVarFromExpression((Expression)fromTerm.getLeftVariable());
        Expression fromExpr = fromTerm.getLeftExpression();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(fromExpr, tupSource);
        if (fromTerm.hasPositionalVariable()) {
            LogicalVariable pVar = this.context.newVarFromExpression((Expression)fromTerm.getPositionalVariable());
            unnestOp = new UnnestOperator(fromVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)eo.first)), pVar, (Object)BuiltinType.AINT64, (IUnnestingPositionWriter)new PositionWriter());
        } else {
            unnestOp = new UnnestOperator(fromVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)eo.first)));
        }
        unnestOp.getInputs().add(eo.second);
        unnestOp.setSourceLocation(sourceLoc);
        MutableObject topOpRef = new MutableObject((Object)unnestOp);
        if (fromTerm.hasCorrelateClauses()) {
            for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
                if (correlateClause.getClauseType() == Clause.ClauseType.UNNEST_CLAUSE) {
                    topOpRef = new MutableObject(((Pair)correlateClause.accept((ILangVisitor)this, (Object)topOpRef)).first);
                    continue;
                }
                this.uncorrelatedLeftBranchStack.push((Mutable<ILogicalOperator>)topOpRef);
                topOpRef = new MutableObject(((Pair)correlateClause.accept((ILangVisitor)this, tupSource)).first);
            }
        }
        return new Pair(topOpRef.getValue(), (Object)fromVar);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(JoinClause joinClause, Mutable<ILogicalOperator> inputRef) throws CompilationException {
        LogicalVariable varToListify;
        boolean hasRightPosVar;
        SourceLocation sourceLoc = joinClause.getSourceLocation();
        Mutable<ILogicalOperator> leftInputRef = this.uncorrelatedLeftBranchStack.pop();
        if (joinClause.getJoinType() == JoinType.INNER) {
            Pair<ILogicalOperator, LogicalVariable> rightBranch = this.generateUnnestForBinaryCorrelateRightBranch((AbstractBinaryCorrelateClause)joinClause, inputRef, true);
            InnerJoinOperator joinOperator = new InnerJoinOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE), leftInputRef, (Mutable)new MutableObject(rightBranch.first));
            joinOperator.setSourceLocation(sourceLoc);
            MutableObject joinOpRef = new MutableObject((Object)joinOperator);
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> conditionExprOpPair = this.langExprToAlgExpression(joinClause.getConditionExpression(), (Mutable<ILogicalOperator>)joinOpRef);
            SelectOperator filter = new SelectOperator((Mutable)new MutableObject(conditionExprOpPair.first), false, null);
            filter.getInputs().add(conditionExprOpPair.second);
            filter.setSourceLocation(((ILogicalExpression)conditionExprOpPair.first).getSourceLocation());
            return new Pair((Object)filter, rightBranch.second);
        }
        SubplanOperator subplanOp = new SubplanOperator();
        subplanOp.getInputs().add(leftInputRef);
        subplanOp.setSourceLocation(sourceLoc);
        NestedTupleSourceOperator ntsOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)subplanOp));
        ntsOp.setSourceLocation(sourceLoc);
        MutableObject ntsRef = new MutableObject((Object)ntsOp);
        this.context.enterSubplan();
        Pair<ILogicalOperator, LogicalVariable> rightBranch = this.generateUnnestForBinaryCorrelateRightBranch((AbstractBinaryCorrelateClause)joinClause, (Mutable<ILogicalOperator>)ntsRef, true);
        AbstractUnnestNonMapOperator rightUnnestOp = (AbstractUnnestNonMapOperator)rightBranch.first;
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> conditionExprOpPair = this.langExprToAlgExpression(joinClause.getConditionExpression(), (Mutable<ILogicalOperator>)new MutableObject((Object)rightUnnestOp));
        SelectOperator filter = new SelectOperator((Mutable)new MutableObject(conditionExprOpPair.first), false, null);
        filter.getInputs().add(conditionExprOpPair.second);
        filter.setSourceLocation(((ILogicalExpression)conditionExprOpPair.first).getSourceLocation());
        SelectOperator currentTopOp = filter;
        boolean bl = hasRightPosVar = rightUnnestOp.getPositionalVariable() != null;
        if (hasRightPosVar) {
            VariableReferenceExpression rightUnnestVarRef = new VariableReferenceExpression(rightUnnestOp.getVariable());
            rightUnnestVarRef.setSourceLocation(joinClause.getRightVariable().getSourceLocation());
            VariableReferenceExpression rightUnnestPosVarRef = new VariableReferenceExpression(rightUnnestOp.getPositionalVariable());
            rightUnnestPosVarRef.setSourceLocation(joinClause.getPositionalVariable().getSourceLocation());
            ScalarFunctionCallExpression recordCreationFunc = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR), new Mutable[]{new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString("unnestvar")))), new MutableObject((Object)rightUnnestVarRef), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString("posvar")))), new MutableObject((Object)rightUnnestPosVarRef)});
            recordCreationFunc.setSourceLocation(joinClause.getRightVariable().getSourceLocation());
            LogicalVariable recordVar = this.context.newVar();
            AssignOperator assignOp = new AssignOperator(recordVar, (Mutable)new MutableObject((Object)recordCreationFunc));
            assignOp.getInputs().add(new MutableObject((Object)currentTopOp));
            assignOp.setSourceLocation(joinClause.getRightVariable().getSourceLocation());
            currentTopOp = assignOp;
            varToListify = recordVar;
        } else {
            varToListify = rightUnnestOp.getVariable();
        }
        VariableReferenceExpression varToListifyRef = new VariableReferenceExpression(varToListify);
        varToListifyRef.setSourceLocation(currentTopOp.getSourceLocation());
        AggregateFunctionCallExpression fListify = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)BuiltinFunctions.LISTIFY, this.mkSingletonArrayList(new MutableObject((Object)varToListifyRef)));
        fListify.setSourceLocation(currentTopOp.getSourceLocation());
        LogicalVariable aggVar = this.context.newSubplanOutputVar();
        AggregateOperator aggOp = new AggregateOperator(this.mkSingletonArrayList(aggVar), this.mkSingletonArrayList(new MutableObject((Object)fListify)));
        aggOp.getInputs().add(new MutableObject((Object)currentTopOp));
        aggOp.setSourceLocation(fListify.getSourceLocation());
        this.context.exitSubplan();
        ALogicalPlanImpl subplan = new ALogicalPlanImpl((Mutable)new MutableObject((Object)aggOp));
        subplanOp.getNestedPlans().add(subplan);
        LogicalVariable outerUnnestVar = this.context.newVar();
        VariableReferenceExpression aggVarRefExpr = new VariableReferenceExpression(aggVar);
        aggVarRefExpr.setSourceLocation(aggOp.getSourceLocation());
        LeftOuterUnnestOperator outerUnnestOp = new LeftOuterUnnestOperator(outerUnnestVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)aggVarRefExpr)));
        outerUnnestOp.getInputs().add(new MutableObject((Object)subplanOp));
        outerUnnestOp.setSourceLocation(aggOp.getSourceLocation());
        currentTopOp = outerUnnestOp;
        if (hasRightPosVar) {
            VariableReferenceExpression outerUnnestVarRef1 = new VariableReferenceExpression(outerUnnestVar);
            outerUnnestVarRef1.setSourceLocation(joinClause.getRightVariable().getSourceLocation());
            ScalarFunctionCallExpression fieldAccessForRightUnnestVar = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_INDEX), new Mutable[]{new MutableObject((Object)outerUnnestVarRef1), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(0))))});
            fieldAccessForRightUnnestVar.setSourceLocation(joinClause.getRightVariable().getSourceLocation());
            VariableReferenceExpression outerUnnestVarRef2 = new VariableReferenceExpression(outerUnnestVar);
            outerUnnestVarRef2.setSourceLocation(joinClause.getPositionalVariable().getSourceLocation());
            ScalarFunctionCallExpression fieldAccessForRightPosVar = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_INDEX), new Mutable[]{new MutableObject((Object)outerUnnestVarRef2), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(1))))});
            fieldAccessForRightPosVar.setSourceLocation(joinClause.getPositionalVariable().getSourceLocation());
            LogicalVariable rightUnnestVar = this.context.newVar();
            LogicalVariable rightPosVar = this.context.newVar();
            this.context.setVar(joinClause.getRightVariable(), rightUnnestVar);
            this.context.setVar(joinClause.getPositionalVariable(), rightPosVar);
            ArrayList<LogicalVariable> assignVars = new ArrayList<LogicalVariable>();
            assignVars.add(rightUnnestVar);
            assignVars.add(rightPosVar);
            ArrayList<MutableObject> assignExprs = new ArrayList<MutableObject>();
            assignExprs.add(new MutableObject((Object)fieldAccessForRightUnnestVar));
            assignExprs.add(new MutableObject((Object)fieldAccessForRightPosVar));
            AssignOperator assignOp = new AssignOperator(assignVars, assignExprs);
            assignOp.getInputs().add(new MutableObject((Object)currentTopOp));
            assignOp.setSourceLocation(joinClause.getRightVariable().getSourceLocation());
            currentTopOp = assignOp;
        } else {
            this.context.setVar(joinClause.getRightVariable(), outerUnnestVar);
        }
        return new Pair((Object)currentTopOp, null);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(NestClause nestClause, Mutable<ILogicalOperator> arg) throws CompilationException {
        throw new CompilationException(1079, nestClause.getSourceLocation(), new Serializable[]{"Nest clause has not been implemented"});
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(UnnestClause unnestClause, Mutable<ILogicalOperator> inputOpRef) throws CompilationException {
        return this.generateUnnestForBinaryCorrelateRightBranch((AbstractBinaryCorrelateClause)unnestClause, inputOpRef, unnestClause.getJoinType() == JoinType.INNER);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(HavingClause havingClause, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression(havingClause.getFilterExpression(), tupSource);
        SelectOperator s = new SelectOperator((Mutable)new MutableObject(p.first), false, null);
        s.getInputs().add(p.second);
        return new Pair((Object)s, null);
    }

    private Pair<ILogicalOperator, LogicalVariable> generateUnnestForBinaryCorrelateRightBranch(AbstractBinaryCorrelateClause binaryCorrelate, Mutable<ILogicalOperator> inputOpRef, boolean innerUnnest) throws CompilationException {
        UnnestOperator unnestOp;
        LogicalVariable rightVar = this.context.newVarFromExpression((Expression)binaryCorrelate.getRightVariable());
        Expression rightExpr = binaryCorrelate.getRightExpression();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(rightExpr, inputOpRef);
        if (binaryCorrelate.hasPositionalVariable()) {
            LogicalVariable pVar = this.context.newVarFromExpression((Expression)binaryCorrelate.getPositionalVariable());
            unnestOp = innerUnnest ? new UnnestOperator(rightVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)eo.first)), pVar, (Object)BuiltinType.AINT64, (IUnnestingPositionWriter)new PositionWriter()) : new LeftOuterUnnestOperator(rightVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)eo.first)), pVar, (Object)BuiltinType.AINT64, (IUnnestingPositionWriter)new PositionWriter());
        } else {
            unnestOp = innerUnnest ? new UnnestOperator(rightVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)eo.first))) : new LeftOuterUnnestOperator(rightVar, (Mutable)new MutableObject((Object)this.makeUnnestExpression((ILogicalExpression)eo.first)));
        }
        unnestOp.getInputs().add(eo.second);
        unnestOp.setSourceLocation(binaryCorrelate.getRightVariable().getSourceLocation());
        return new Pair((Object)unnestOp, (Object)rightVar);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectClause selectClause, Mutable<ILogicalOperator> tupSrc) throws CompilationException {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectElement selectElement, Mutable<ILogicalOperator> arg) throws CompilationException {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectRegular selectRegular, Mutable<ILogicalOperator> arg) throws CompilationException {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(Projection projection, Mutable<ILogicalOperator> arg) throws CompilationException {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(CaseExpression caseExpression, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        MutableObject currentOpRef = tupSource;
        ILogicalOperator currentOperator = null;
        List whenExprList = caseExpression.getWhenExprs();
        List thenExprList = caseExpression.getThenExprs();
        ArrayList<ILogicalExpression> branchCondVarReferences = new ArrayList<ILogicalExpression>();
        ArrayList<VariableReferenceExpression> allVarReferences = new ArrayList<VariableReferenceExpression>();
        for (int index = 0; index < whenExprList.size(); ++index) {
            Expression whenExpr = (Expression)whenExprList.get(index);
            Pair whenExprResult = (Pair)whenExpr.accept((ILangVisitor)this, (Object)currentOpRef);
            currentOperator = (ILogicalOperator)whenExprResult.first;
            LogicalVariable whenConditionVar = (LogicalVariable)whenExprResult.second;
            VariableReferenceExpression whenConditionVarRef1 = new VariableReferenceExpression(whenConditionVar);
            whenConditionVarRef1.setSourceLocation(whenExpr.getSourceLocation());
            Object branchEntraceConditionExprRef = new MutableObject((Object)whenConditionVarRef1);
            if (!branchCondVarReferences.isEmpty()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this.generateNoMatchedPrecedingWhenBranchesFilter(branchCondVarReferences, caseExpression.getSourceLocation()));
                arrayList.add(branchEntraceConditionExprRef);
                ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), arrayList);
                andExpr.setSourceLocation(whenExpr.getSourceLocation());
                branchEntraceConditionExprRef = new MutableObject((Object)andExpr);
            }
            Expression expression = (Expression)thenExprList.get(index);
            Pair<ILogicalOperator, LogicalVariable> opAndVarForThen = this.constructSubplanOperatorForBranch(currentOperator, (Mutable<ILogicalExpression>)branchEntraceConditionExprRef, expression);
            VariableReferenceExpression whenConditionVarRef2 = new VariableReferenceExpression(whenConditionVar);
            whenConditionVarRef2.setSourceLocation(whenExpr.getSourceLocation());
            branchCondVarReferences.add((ILogicalExpression)whenConditionVarRef2);
            VariableReferenceExpression whenConditionVarRef3 = new VariableReferenceExpression(whenConditionVar);
            whenConditionVarRef3.setSourceLocation(whenExpr.getSourceLocation());
            allVarReferences.add(whenConditionVarRef3);
            VariableReferenceExpression thenVarRef = new VariableReferenceExpression((LogicalVariable)opAndVarForThen.second);
            thenVarRef.setSourceLocation(expression.getSourceLocation());
            allVarReferences.add(thenVarRef);
            currentOperator = (ILogicalOperator)opAndVarForThen.first;
            currentOpRef = new MutableObject((Object)currentOperator);
        }
        Mutable<ILogicalExpression> elseCondExprRef = this.generateNoMatchedPrecedingWhenBranchesFilter(branchCondVarReferences, caseExpression.getSourceLocation());
        Expression elseExpr = caseExpression.getElseExpr();
        Pair<ILogicalOperator, LogicalVariable> opAndVarForElse = this.constructSubplanOperatorForBranch(currentOperator, elseCondExprRef, elseExpr);
        LogicalVariable selectVar = this.context.newVar();
        ArrayList<MutableObject> arguments = new ArrayList<MutableObject>();
        arguments.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)ABoolean.TRUE))));
        for (ILogicalExpression iLogicalExpression : allVarReferences) {
            arguments.add(new MutableObject((Object)iLogicalExpression));
        }
        VariableReferenceExpression varForElseRef = new VariableReferenceExpression((LogicalVariable)opAndVarForElse.second);
        varForElseRef.setSourceLocation(elseExpr.getSourceLocation());
        arguments.add(new MutableObject((Object)varForElseRef));
        ScalarFunctionCallExpression scalarFunctionCallExpression = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SWITCH_CASE), arguments);
        scalarFunctionCallExpression.setSourceLocation(caseExpression.getSourceLocation());
        AssignOperator assignOp = new AssignOperator(selectVar, (Mutable)new MutableObject((Object)scalarFunctionCallExpression));
        assignOp.getInputs().add(new MutableObject(opAndVarForElse.first));
        assignOp.setSourceLocation(caseExpression.getSourceLocation());
        LogicalVariable unnestVar = this.context.newVar();
        VariableReferenceExpression selectVarRef = new VariableReferenceExpression(selectVar);
        selectVarRef.setSourceLocation(caseExpression.getSourceLocation());
        UnnestingFunctionCallExpression scanCollectionExpr = new UnnestingFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), Collections.singletonList(new MutableObject((Object)selectVarRef)));
        scanCollectionExpr.setSourceLocation(caseExpression.getSourceLocation());
        UnnestOperator unnestOp = new UnnestOperator(unnestVar, (Mutable)new MutableObject((Object)scanCollectionExpr));
        unnestOp.getInputs().add(new MutableObject((Object)assignOp));
        unnestOp.setSourceLocation(caseExpression.getSourceLocation());
        LogicalVariable resultVar = this.context.newVar();
        VariableReferenceExpression unnestVarRef = new VariableReferenceExpression(unnestVar);
        unnestVarRef.setSourceLocation(caseExpression.getSourceLocation());
        AssignOperator finalAssignOp = new AssignOperator(resultVar, (Mutable)new MutableObject((Object)unnestVarRef));
        finalAssignOp.getInputs().add(new MutableObject((Object)unnestOp));
        finalAssignOp.setSourceLocation(caseExpression.getSourceLocation());
        return new Pair((Object)finalAssignOp, (Object)resultVar);
    }

    @Override
    protected ILogicalExpression translateVariableRef(VariableExpr varExpr) throws CompilationException {
        VarIdentifier varId = varExpr.getVar();
        if (SqlppVariableUtil.isExternalVariableIdentifier((VarIdentifier)varId)) {
            SourceLocation sourceLoc = varExpr.getSourceLocation();
            IAObject value = this.getExternalVariableValue(varId, sourceLoc);
            return this.translateConstantValue(value, sourceLoc);
        }
        return super.translateVariableRef(varExpr);
    }

    private IAObject getExternalVariableValue(VarIdentifier varId, SourceLocation sourceLoc) throws CompilationException {
        IAObject value = this.externalVars.get(varId);
        if (value == null) {
            throw new CompilationException(1038, sourceLoc, new Serializable[]{varId.toString()});
        }
        return value;
    }

    private ILogicalExpression translateConstantValue(IAObject value, SourceLocation sourceLoc) throws CompilationException {
        ConstantExpression constExpr = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(value));
        constExpr.setSourceLocation(sourceLoc);
        IAType valueType = value.getType();
        if (valueType.getTypeTag().isDerivedType()) {
            ScalarFunctionCallExpression castExpr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CAST_TYPE));
            castExpr.setSourceLocation(sourceLoc);
            castExpr.getArguments().add(new MutableObject((Object)constExpr));
            TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)castExpr, (IAType)BuiltinType.ANY, (IAType)valueType);
            return castExpr;
        }
        return constExpr;
    }

    private Pair<ILogicalOperator, LogicalVariable> produceSelectPlan(boolean isSubquery, Mutable<ILogicalOperator> returnOpRef, LogicalVariable resVar) {
        if (isSubquery) {
            return this.aggListifyForSubquery(resVar, returnOpRef, false);
        }
        ProjectOperator pr = new ProjectOperator(resVar);
        pr.getInputs().add(returnOpRef);
        pr.setSourceLocation(((ILogicalOperator)returnOpRef.getValue()).getSourceLocation());
        return new Pair((Object)pr, (Object)resVar);
    }

    private Pair<ILogicalOperator, LogicalVariable> processSelectClause(SelectBlock selectBlock, Mutable<ILogicalOperator> tupSrc) throws CompilationException {
        LogicalVariable returnVar;
        ILogicalOperator returnOperator;
        SelectClause selectClause = selectBlock.getSelectClause();
        Expression returnExpr = selectClause.selectElement() ? selectClause.getSelectElement().getExpression() : this.generateReturnExpr(selectClause.getSelectRegular(), selectBlock);
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(returnExpr, tupSrc);
        SourceLocation sourceLoc = returnExpr.getSourceLocation();
        if (returnExpr.getKind() == Expression.Kind.VARIABLE_EXPRESSION && ((ILogicalExpression)eo.first).getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            VariableExpr varExpr = (VariableExpr)returnExpr;
            returnOperator = (ILogicalOperator)((Mutable)eo.second).getValue();
            returnVar = this.context.getVar(varExpr.getVar().getId());
        } else {
            returnVar = this.context.newVar();
            AssignOperator assignOp = new AssignOperator(returnVar, (Mutable)new MutableObject(eo.first));
            assignOp.getInputs().add(eo.second);
            assignOp.setSourceLocation(sourceLoc);
            returnOperator = assignOp;
        }
        if (selectClause.distinct()) {
            VariableReferenceExpression returnVarRef = new VariableReferenceExpression(returnVar);
            returnVarRef.setSourceLocation(sourceLoc);
            DistinctOperator distinctOperator = new DistinctOperator(this.mkSingletonArrayList(new MutableObject((Object)returnVarRef)));
            distinctOperator.getInputs().add(new MutableObject((Object)returnOperator));
            distinctOperator.setSourceLocation(returnOperator.getSourceLocation());
            return new Pair((Object)distinctOperator, (Object)returnVar);
        }
        return new Pair((Object)returnOperator, (Object)returnVar);
    }

    private Expression generateReturnExpr(SelectRegular selectRegular, SelectBlock selectBlock) throws CompilationException {
        ArrayList<Object> recordExprs = new ArrayList<Object>();
        ArrayList<FieldBinding> fieldBindings = new ArrayList<FieldBinding>();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Projection projection : selectRegular.getProjections()) {
            if (projection.varStar()) {
                if (!fieldBindings.isEmpty()) {
                    RecordConstructor recordConstr = new RecordConstructor(new ArrayList(fieldBindings));
                    recordConstr.setSourceLocation(selectRegular.getSourceLocation());
                    recordExprs.add(recordConstr);
                    fieldBindings.clear();
                }
                Expression projectionExpr = projection.getExpression();
                SourceLocation sourceLoc = projection.getSourceLocation();
                CallExpr toObjectExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.TO_OBJECT), Collections.singletonList(projectionExpr));
                toObjectExpr.setSourceLocation(sourceLoc);
                CallExpr ifMissingOrNullExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.IF_MISSING_OR_NULL), Arrays.asList(toObjectExpr, new RecordConstructor(Collections.emptyList())));
                ifMissingOrNullExpr.setSourceLocation(sourceLoc);
                recordExprs.add(ifMissingOrNullExpr);
                continue;
            }
            if (projection.star()) {
                if (selectBlock.hasGroupbyClause()) {
                    this.getGroupBindings(selectBlock.getGroupbyClause(), fieldBindings, fieldNames);
                    if (!selectBlock.hasLetClausesAfterGroupby()) continue;
                    this.getLetBindings(selectBlock.getLetListAfterGroupby(), fieldBindings, fieldNames);
                    continue;
                }
                if (selectBlock.hasFromClause()) {
                    this.getFromBindings(selectBlock.getFromClause(), fieldBindings, fieldNames);
                    if (!selectBlock.hasLetClauses()) continue;
                    this.getLetBindings(selectBlock.getLetList(), fieldBindings, fieldNames);
                    continue;
                }
                if (!selectBlock.hasLetClauses()) continue;
                this.getLetBindings(selectBlock.getLetList(), fieldBindings, fieldNames);
                continue;
            }
            if (projection.hasName()) {
                fieldBindings.add(this.getFieldBinding(projection, fieldNames));
                continue;
            }
            throw new CompilationException(1038, projection.getSourceLocation(), new Serializable[0]);
        }
        if (!fieldBindings.isEmpty()) {
            RecordConstructor recordConstr = new RecordConstructor(fieldBindings);
            recordConstr.setSourceLocation(selectRegular.getSourceLocation());
            recordExprs.add(recordConstr);
        }
        if (recordExprs.size() == 1) {
            return (Expression)recordExprs.get(0);
        }
        CallExpr recordConcatExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.RECORD_CONCAT_STRICT), recordExprs);
        recordConcatExpr.setSourceLocation(selectRegular.getSourceLocation());
        return recordConcatExpr;
    }

    private void getFromBindings(FromClause fromClause, List<FieldBinding> outFieldBindings, Set<String> outFieldNames) throws CompilationException {
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            outFieldBindings.add(this.getFieldBinding(fromTerm.getLeftVariable(), outFieldNames));
            if (fromTerm.hasPositionalVariable()) {
                outFieldBindings.add(this.getFieldBinding(fromTerm.getPositionalVariable(), outFieldNames));
            }
            if (!fromTerm.hasCorrelateClauses()) continue;
            for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
                outFieldBindings.add(this.getFieldBinding(correlateClause.getRightVariable(), outFieldNames));
                if (!correlateClause.hasPositionalVariable()) continue;
                outFieldBindings.add(this.getFieldBinding(correlateClause.getPositionalVariable(), outFieldNames));
            }
        }
    }

    private void getGroupBindings(GroupbyClause groupbyClause, List<FieldBinding> outFieldBindings, Set<String> outFieldNames) throws CompilationException {
        for (GbyVariableExpressionPair pair : groupbyClause.getGbyPairList()) {
            outFieldBindings.add(this.getFieldBinding(pair.getVar(), outFieldNames));
        }
        if (groupbyClause.hasGroupVar()) {
            outFieldBindings.add(this.getFieldBinding(groupbyClause.getGroupVar(), outFieldNames));
        }
        if (groupbyClause.hasWithMap()) {
            throw new CompilationException(1038, groupbyClause.getSourceLocation(), new Serializable[]{groupbyClause.getWithVarMap().values().toString()});
        }
    }

    private void getLetBindings(List<LetClause> letClauses, List<FieldBinding> outFieldBindings, Set<String> outFieldNames) throws CompilationException {
        for (LetClause letClause : letClauses) {
            outFieldBindings.add(this.getFieldBinding(letClause.getVarExpr(), outFieldNames));
        }
    }

    private FieldBinding getFieldBinding(VariableExpr varExpr, Set<String> outFieldNames) throws CompilationException {
        String fieldName = SqlppVariableUtil.variableNameToDisplayedFieldName((String)varExpr.getVar().getValue());
        return this.generateFieldBinding(fieldName, (Expression)varExpr, outFieldNames, varExpr.getSourceLocation());
    }

    private FieldBinding getFieldBinding(Projection projection, Set<String> outFieldNames) throws CompilationException {
        String fieldName = projection.getName();
        Expression fieldValueExpr = projection.getExpression();
        return this.generateFieldBinding(fieldName, fieldValueExpr, outFieldNames, projection.getSourceLocation());
    }

    private FieldBinding generateFieldBinding(String fieldName, Expression fieldValueExpr, Set<String> outFieldNames, SourceLocation sourceLoc) throws CompilationException {
        if (!outFieldNames.add(fieldName)) {
            throw new CompilationException(13, sourceLoc, new Serializable[]{fieldName});
        }
        return new FieldBinding((Expression)new LiteralExpr((Literal)new StringLiteral(fieldName)), fieldValueExpr);
    }

    @Override
    protected boolean expressionNeedsNoNesting(Expression expr) {
        return super.expressionNeedsNoNesting(expr) || this.translateInAsOr && expr.getKind() == Expression.Kind.QUANTIFIED_EXPRESSION && this.isInOperatorWithStaticList((QuantifiedExpression)expr);
    }

    @Override
    public Pair<ILogicalOperator, LogicalVariable> visit(QuantifiedExpression qe, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        return this.translateInAsOr && this.isInOperatorWithStaticList(qe) ? this.translateInOperatorWithStaticList(qe, tupSource) : super.visit(qe, tupSource);
    }

    private boolean isInOperatorWithStaticList(QuantifiedExpression qe) {
        if (qe.getQuantifier() != QuantifiedExpression.Quantifier.SOME) {
            return false;
        }
        List qpList = qe.getQuantifiedList();
        if (qpList.size() != 1) {
            return false;
        }
        QuantifiedPair qp = (QuantifiedPair)qpList.get(0);
        Expression condExpr = qe.getSatisfiesExpr();
        if (condExpr.getKind() != Expression.Kind.OP_EXPRESSION) {
            return false;
        }
        OperatorExpr opExpr = (OperatorExpr)condExpr;
        if (opExpr.getOpList().get(0) != OperatorType.EQ) {
            return false;
        }
        List operandExprs = opExpr.getExprList();
        if (operandExprs.size() != 2) {
            return false;
        }
        int varPos = operandExprs.indexOf(qp.getVarExpr());
        if (varPos < 0) {
            return false;
        }
        Expression inExpr = qp.getExpr();
        switch (inExpr.getKind()) {
            case LIST_CONSTRUCTOR_EXPRESSION: {
                ListConstructor listExpr = (ListConstructor)inExpr;
                List itemExprs = listExpr.getExprList();
                if (itemExprs.isEmpty()) {
                    return false;
                }
                for (Expression itemExpr : itemExprs) {
                    boolean isConst = itemExpr.getKind() == Expression.Kind.LITERAL_EXPRESSION || itemExpr.getKind() == Expression.Kind.VARIABLE_EXPRESSION && SqlppVariableUtil.isExternalVariableReference((VariableExpr)((VariableExpr)itemExpr));
                    if (isConst) continue;
                    return false;
                }
                return true;
            }
            case VARIABLE_EXPRESSION: {
                VarIdentifier inVarId = ((VariableExpr)inExpr).getVar();
                if (!SqlppVariableUtil.isExternalVariableIdentifier((VarIdentifier)inVarId)) {
                    return false;
                }
                IAObject inValue = this.externalVars.get(inVarId);
                return inValue != null && inValue.getType().getTypeTag().isListType() && ((IACollection)inValue).size() > 0;
            }
        }
        return false;
    }

    private Pair<ILogicalOperator, LogicalVariable> translateInOperatorWithStaticList(QuantifiedExpression qe, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        MutableObject condExpr;
        SourceLocation sourceLoc = qe.getSourceLocation();
        QuantifiedPair qp = (QuantifiedPair)qe.getQuantifiedList().get(0);
        VariableExpr varExpr = qp.getVarExpr();
        List operandExprs = ((OperatorExpr)qe.getSatisfiesExpr()).getExprList();
        int varIdx = operandExprs.indexOf(varExpr);
        Expression operandExpr = (Expression)operandExprs.get(1 - varIdx);
        Mutable topOp = tupSource;
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo1 = this.langExprToAlgExpression(operandExpr, topOp);
        topOp = (Mutable)eo1.second;
        LogicalVariable operandVar = this.context.newVar();
        AssignOperator operandAssign = new AssignOperator(operandVar, (Mutable)new MutableObject(eo1.first));
        operandAssign.getInputs().add(topOp);
        operandAssign.setSourceLocation(sourceLoc);
        topOp = new MutableObject((Object)operandAssign);
        ArrayList<MutableObject> disjuncts = new ArrayList<MutableObject>();
        Expression inExpr = qp.getExpr();
        switch (inExpr.getKind()) {
            case LIST_CONSTRUCTOR_EXPRESSION: {
                ListConstructor listExpr = (ListConstructor)inExpr;
                for (Expression itemExpr : listExpr.getExprList()) {
                    IAObject inValue;
                    switch (itemExpr.getKind()) {
                        case LITERAL_EXPRESSION: {
                            inValue = ConstantHelper.objectFromLiteral(((LiteralExpr)itemExpr).getValue());
                            break;
                        }
                        case VARIABLE_EXPRESSION: {
                            inValue = this.getExternalVariableValue(((VariableExpr)itemExpr).getVar(), sourceLoc);
                            break;
                        }
                        default: {
                            throw new CompilationException(1038, sourceLoc, new Serializable[]{itemExpr.getKind()});
                        }
                    }
                    ILogicalExpression eqExpr = this.createEqExpr(operandVar, inValue, sourceLoc);
                    disjuncts.add(new MutableObject((Object)eqExpr));
                }
                break;
            }
            case VARIABLE_EXPRESSION: {
                VarIdentifier inVarId = ((VariableExpr)inExpr).getVar();
                IAObject inVarValue = this.externalVars.get(inVarId);
                IACursor inVarCursor = ((IACollection)inVarValue).getCursor();
                inVarCursor.reset();
                while (inVarCursor.next()) {
                    IAObject inValue = inVarCursor.get();
                    ILogicalExpression eqExpr = this.createEqExpr(operandVar, inValue, sourceLoc);
                    disjuncts.add(new MutableObject((Object)eqExpr));
                }
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(inExpr.getKind()));
            }
        }
        if (disjuncts.size() == 1) {
            condExpr = (MutableObject)disjuncts.get(0);
        } else {
            AbstractFunctionCallExpression orExpr = SqlppExpressionToPlanTranslator.createFunctionCallExpressionForBuiltinOperator(OperatorType.OR, sourceLoc);
            orExpr.getArguments().addAll(disjuncts);
            condExpr = new MutableObject((Object)orExpr);
        }
        LogicalVariable assignVar = this.context.newVar();
        AssignOperator assignOp = new AssignOperator(assignVar, (Mutable)condExpr);
        assignOp.getInputs().add(topOp);
        assignOp.setSourceLocation(sourceLoc);
        return new Pair((Object)assignOp, (Object)assignVar);
    }

    private ILogicalExpression createEqExpr(LogicalVariable lhsVar, IAObject rhsValue, SourceLocation sourceLoc) throws CompilationException {
        VariableReferenceExpression lhsExpr = new VariableReferenceExpression(lhsVar);
        lhsExpr.setSourceLocation(sourceLoc);
        ILogicalExpression rhsExpr = this.translateConstantValue(rhsValue, sourceLoc);
        AbstractFunctionCallExpression opExpr = SqlppExpressionToPlanTranslator.createFunctionCallExpressionForBuiltinOperator(OperatorType.EQ, sourceLoc);
        opExpr.getArguments().add(new MutableObject((Object)lhsExpr));
        opExpr.getArguments().add(new MutableObject((Object)rhsExpr));
        return opExpr;
    }
}

