/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.subplan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.util.EquivalenceClassUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.LogicalOperatorDeepCopyWithNewVariablesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.algebra.visitors.IQueryOperatorVisitor;
import org.apache.hyracks.api.exceptions.SourceLocation;

class InlineAllNtsInSubplanVisitor
implements IQueryOperatorVisitor<ILogicalOperator, Void> {
    private final IOptimizationContext context;
    private final ILogicalOperator subplanOperator;
    private final ILogicalOperator subplanInputOperator;
    private final LinkedHashMap<LogicalVariable, LogicalVariable> subplanInputVarToCurrentVarMap = new LinkedHashMap();
    private final Map<LogicalVariable, LogicalVariable> currentVarToSubplanInputVarMap = new HashMap<LogicalVariable, LogicalVariable>();
    private final Set<LogicalVariable> correlatedKeyVars = new HashSet<LogicalVariable>();
    private final List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderingExprs = new ArrayList<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>>();
    private final List<Pair<LogicalVariable, LogicalVariable>> varMapIntroducedByRewriting = new ArrayList<Pair<LogicalVariable, LogicalVariable>>();

    public InlineAllNtsInSubplanVisitor(IOptimizationContext context, ILogicalOperator subplanOperator) throws AlgebricksException {
        this.context = context;
        this.subplanOperator = subplanOperator;
        this.subplanInputOperator = (ILogicalOperator)((Mutable)subplanOperator.getInputs().get(0)).getValue();
    }

    public Map<LogicalVariable, LogicalVariable> getInputVariableToOutputVariableMap() {
        return this.subplanInputVarToCurrentVarMap;
    }

    public List<Pair<LogicalVariable, LogicalVariable>> getVariableMapHistory() {
        return this.varMapIntroducedByRewriting;
    }

    public List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> getOrderingExpressions() {
        return this.orderingExprs;
    }

    public ILogicalOperator visitAggregateOperator(AggregateOperator op, Void arg) throws AlgebricksException {
        return this.visitAggregateOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitRunningAggregateOperator(RunningAggregateOperator op, Void arg) throws AlgebricksException {
        return this.visitAggregateOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitGroupByOperator(GroupByOperator op, Void arg) throws AlgebricksException {
        VariableReferenceExpression varExpr;
        ILogicalExpression expr;
        this.visitSingleInputOperator((ILogicalOperator)op);
        HashSet<Object> groupKeyVars = new HashSet<Object>();
        for (Object keyVarExprRef : op.getGroupByList()) {
            expr = (ILogicalExpression)((Mutable)((Pair)keyVarExprRef).second).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            varExpr = (VariableReferenceExpression)expr;
            LogicalVariable sourceVar = varExpr.getVariableReference();
            this.updateInputToOutputVarMapping(sourceVar, (LogicalVariable)((Pair)keyVarExprRef).first, false);
            groupKeyVars.add(((Pair)keyVarExprRef).first);
        }
        HashMap<LogicalVariable, LogicalVariable> addedGroupKeyMapping = new HashMap<LogicalVariable, LogicalVariable>();
        for (LogicalVariable keyVar : this.correlatedKeyVars) {
            if (groupKeyVars.contains(keyVar)) continue;
            LogicalVariable newVar = this.context.newVar();
            VariableReferenceExpression keyVarRef = new VariableReferenceExpression(keyVar);
            keyVarRef.setSourceLocation(op.getSourceLocation());
            op.getGroupByList().add(new Pair((Object)newVar, (Object)new MutableObject((Object)keyVarRef)));
            addedGroupKeyMapping.put(keyVar, newVar);
        }
        Iterator decorExprIter = op.getDecorList().iterator();
        while (decorExprIter.hasNext()) {
            expr = (ILogicalExpression)((Mutable)((Pair)decorExprIter.next()).second).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE || !this.correlatedKeyVars.contains((varExpr = (VariableReferenceExpression)expr).getVariableReference())) continue;
            decorExprIter.remove();
        }
        addedGroupKeyMapping.forEach((key, value) -> this.updateInputToOutputVarMapping((LogicalVariable)key, (LogicalVariable)value, false));
        return op;
    }

    public ILogicalOperator visitLimitOperator(LimitOperator op, Void arg) throws AlgebricksException {
        this.visitSingleInputOperator((ILogicalOperator)op);
        if (this.correlatedKeyVars.isEmpty()) {
            return op;
        }
        HashSet<LogicalVariable> inputLiveVars = new HashSet<LogicalVariable>();
        VariableUtilities.getSubplanLocalLiveVariables((ILogicalOperator)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()), inputLiveVars);
        Pair<ILogicalOperator, LogicalVariable> assignOpAndRecordVar = this.createRecordConstructorAssignOp(inputLiveVars, op.getSourceLocation());
        ILogicalOperator assignOp = (ILogicalOperator)assignOpAndRecordVar.first;
        LogicalVariable recordVar = (LogicalVariable)assignOpAndRecordVar.second;
        ILogicalOperator inputOp = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        assignOp.getInputs().add(new MutableObject((Object)inputOp));
        Pair<ILogicalOperator, LogicalVariable> gbyOpAndAggVar = this.wrapLimitInGroupBy((ILogicalOperator)op, recordVar, inputLiveVars);
        ILogicalOperator gbyOp = (ILogicalOperator)gbyOpAndAggVar.first;
        LogicalVariable aggVar = (LogicalVariable)gbyOpAndAggVar.second;
        gbyOp.getInputs().add(new MutableObject((Object)assignOp));
        Pair<ILogicalOperator, LogicalVariable> unnestOpAndUnnestVar = this.createUnnestForAggregatedList(aggVar, op.getSourceLocation());
        ILogicalOperator unnestOp = (ILogicalOperator)unnestOpAndUnnestVar.first;
        LogicalVariable unnestVar = (LogicalVariable)unnestOpAndUnnestVar.second;
        unnestOp.getInputs().add(new MutableObject((Object)gbyOp));
        ILogicalOperator fieldAccessAssignOp = this.createFieldAccessAssignOperator(unnestVar, inputLiveVars, op.getSourceLocation());
        fieldAccessAssignOp.getInputs().add(new MutableObject((Object)unnestOp));
        OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)fieldAccessAssignOp, (ITypingContext)this.context);
        return fieldAccessAssignOp;
    }

    private Pair<ILogicalOperator, LogicalVariable> createRecordConstructorAssignOp(Set<LogicalVariable> inputLiveVars, SourceLocation sourceLoc) {
        ArrayList<MutableObject> recordConstructorArgs = new ArrayList<MutableObject>();
        for (LogicalVariable inputLiveVar : inputLiveVars) {
            if (this.correlatedKeyVars.contains(inputLiveVar)) continue;
            recordConstructorArgs.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(Integer.toString(inputLiveVar.getId()))))));
            VariableReferenceExpression inputLiveVarRef = new VariableReferenceExpression(inputLiveVar);
            inputLiveVarRef.setSourceLocation(sourceLoc);
            recordConstructorArgs.add(new MutableObject((Object)inputLiveVarRef));
        }
        LogicalVariable recordVar = this.context.newVar();
        ScalarFunctionCallExpression openRecConstr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR), recordConstructorArgs);
        openRecConstr.setSourceLocation(sourceLoc);
        MutableObject recordExprRef = new MutableObject((Object)openRecConstr);
        AssignOperator assignOp = new AssignOperator(recordVar, (Mutable)recordExprRef);
        assignOp.setSourceLocation(sourceLoc);
        return new Pair((Object)assignOp, (Object)recordVar);
    }

    private Pair<ILogicalOperator, LogicalVariable> wrapLimitInGroupBy(ILogicalOperator op, LogicalVariable recordVar, Set<LogicalVariable> inputLiveVars) throws AlgebricksException {
        SourceLocation sourceLoc = op.getSourceLocation();
        GroupByOperator gbyOp = new GroupByOperator();
        gbyOp.setSourceLocation(sourceLoc);
        ArrayList<Pair> keyVarNewVarPairs = new ArrayList<Pair>();
        for (LogicalVariable keyVar : this.correlatedKeyVars) {
            LogicalVariable newVar = this.context.newVar();
            VariableReferenceExpression keyVarRef = new VariableReferenceExpression(keyVar);
            keyVarRef.setSourceLocation(sourceLoc);
            gbyOp.getGroupByList().add(new Pair((Object)newVar, (Object)new MutableObject((Object)keyVarRef)));
            keyVarNewVarPairs.add(new Pair((Object)keyVar, (Object)newVar));
        }
        ArrayList<LogicalVariable> aggVarList = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> aggExprList = new ArrayList<MutableObject>();
        LogicalVariable aggVar = this.context.newVar();
        ArrayList<MutableObject> aggArgList = new ArrayList<MutableObject>();
        aggVarList.add(aggVar);
        VariableReferenceExpression recordVarRef = new VariableReferenceExpression(recordVar);
        recordVarRef.setSourceLocation(sourceLoc);
        aggArgList.add(new MutableObject((Object)recordVarRef));
        AggregateFunctionCallExpression aggExpr = new AggregateFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.LISTIFY), false, aggArgList);
        aggExpr.setSourceLocation(sourceLoc);
        aggExprList.add(new MutableObject((Object)aggExpr));
        AggregateOperator aggOp = new AggregateOperator(aggVarList, aggExprList);
        aggOp.setSourceLocation(sourceLoc);
        aggOp.getInputs().add(new MutableObject((Object)op));
        op.getInputs().clear();
        ILogicalOperator currentOp = op;
        if (!this.orderingExprs.isEmpty()) {
            OrderOperator orderOp = new OrderOperator(this.cloneOrderingExpression(this.orderingExprs));
            orderOp.setSourceLocation(sourceLoc);
            op.getInputs().add(new MutableObject((Object)orderOp));
            currentOp = orderOp;
        }
        NestedTupleSourceOperator nts = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)gbyOp));
        nts.setSourceLocation(sourceLoc);
        currentOp.getInputs().add(new MutableObject((Object)nts));
        ALogicalPlanImpl nestedPlan = new ALogicalPlanImpl();
        nestedPlan.getRoots().add(new MutableObject((Object)aggOp));
        gbyOp.getNestedPlans().add(nestedPlan);
        for (Pair keyVarNewVar : keyVarNewVarPairs) {
            this.updateInputToOutputVarMapping((LogicalVariable)keyVarNewVar.first, (LogicalVariable)keyVarNewVar.second, false);
        }
        return new Pair((Object)gbyOp, (Object)aggVar);
    }

    private Pair<ILogicalOperator, LogicalVariable> createUnnestForAggregatedList(LogicalVariable aggVar, SourceLocation sourceLoc) {
        LogicalVariable unnestVar = this.context.newVar();
        VariableReferenceExpression aggVarRef = new VariableReferenceExpression(aggVar);
        aggVarRef.setSourceLocation(sourceLoc);
        MutableObject unnestArg = new MutableObject((Object)aggVarRef);
        ArrayList<MutableObject> unnestArgList = new ArrayList<MutableObject>();
        unnestArgList.add(unnestArg);
        UnnestingFunctionCallExpression unnestExpr = new UnnestingFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), unnestArgList);
        unnestExpr.setSourceLocation(sourceLoc);
        UnnestOperator unnestOp = new UnnestOperator(unnestVar, (Mutable)new MutableObject((Object)unnestExpr));
        unnestOp.setSourceLocation(sourceLoc);
        return new Pair((Object)unnestOp, (Object)unnestVar);
    }

    private ILogicalOperator createFieldAccessAssignOperator(LogicalVariable recordVar, Set<LogicalVariable> inputLiveVars, SourceLocation sourceLoc) {
        ArrayList<LogicalVariable> fieldAccessVars = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> fieldAccessExprs = new ArrayList<MutableObject>();
        for (LogicalVariable inputLiveVar : inputLiveVars) {
            if (this.correlatedKeyVars.contains(inputLiveVar)) continue;
            LogicalVariable newVar = this.context.newVar();
            fieldAccessVars.add(newVar);
            ArrayList<MutableObject> argRefs = new ArrayList<MutableObject>();
            VariableReferenceExpression recordVarRef = new VariableReferenceExpression(recordVar);
            recordVarRef.setSourceLocation(sourceLoc);
            argRefs.add(new MutableObject((Object)recordVarRef));
            argRefs.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(Integer.toString(inputLiveVar.getId()))))));
            ScalarFunctionCallExpression faExpr = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_NAME), argRefs);
            faExpr.setSourceLocation(sourceLoc);
            fieldAccessExprs.add(new MutableObject((Object)faExpr));
            this.updateInputToOutputVarMapping(inputLiveVar, newVar, false);
        }
        AssignOperator assignOp = new AssignOperator(fieldAccessVars, fieldAccessExprs);
        assignOp.setSourceLocation(sourceLoc);
        return assignOp;
    }

    public ILogicalOperator visitInnerJoinOperator(InnerJoinOperator op, Void arg) throws AlgebricksException {
        return this.visitMultiInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void arg) throws AlgebricksException {
        return this.visitMultiInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void arg) throws AlgebricksException {
        if (op.getDataSourceReference().getValue() != this.subplanOperator) {
            return op;
        }
        LogicalOperatorDeepCopyWithNewVariablesVisitor deepCopyVisitor = new LogicalOperatorDeepCopyWithNewVariablesVisitor((IVariableContext)this.context, (ITypingContext)this.context);
        ILogicalOperator copiedInputOperator = deepCopyVisitor.deepCopy(this.subplanInputOperator);
        LinkedHashMap varMap = deepCopyVisitor.getInputToOutputVariableMapping();
        this.addPrimaryKeys(varMap);
        Pair<ILogicalOperator, Set<LogicalVariable>> primaryOpAndVars = EquivalenceClassUtils.findOrCreatePrimaryKeyOpAndVariables(copiedInputOperator, true, this.context);
        this.correlatedKeyVars.clear();
        this.correlatedKeyVars.addAll((Collection)primaryOpAndVars.second);
        varMap.forEach((oldVar, newVar) -> {
            if (this.correlatedKeyVars.contains(oldVar)) {
                this.correlatedKeyVars.remove(oldVar);
                this.correlatedKeyVars.add((LogicalVariable)newVar);
            }
            this.updateInputToOutputVarMapping((LogicalVariable)oldVar, (LogicalVariable)newVar, true);
        });
        return (ILogicalOperator)primaryOpAndVars.first;
    }

    public ILogicalOperator visitOrderOperator(OrderOperator op, Void arg) throws AlgebricksException {
        this.visitSingleInputOperator((ILogicalOperator)op);
        if (this.correlatedKeyVars.isEmpty()) {
            return op;
        }
        this.orderingExprs.clear();
        this.orderingExprs.addAll(this.cloneOrderingExpression(op.getOrderExpressions()));
        ArrayList<Pair> orderExprList = new ArrayList<Pair>();
        for (LogicalVariable keyVar : this.correlatedKeyVars) {
            VariableReferenceExpression keyVarRef = new VariableReferenceExpression(keyVar);
            keyVarRef.setSourceLocation(op.getSourceLocation());
            orderExprList.add(new Pair((Object)OrderOperator.ASC_ORDER, (Object)new MutableObject((Object)keyVarRef)));
        }
        orderExprList.addAll(op.getOrderExpressions());
        OrderOperator orderOp = new OrderOperator(orderExprList);
        orderOp.setSourceLocation(op.getSourceLocation());
        orderOp.getInputs().addAll(op.getInputs());
        this.context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)orderOp);
        return orderOp;
    }

    public ILogicalOperator visitAssignOperator(AssignOperator op, Void arg) throws AlgebricksException {
        this.visitSingleInputOperator((ILogicalOperator)op);
        List assignedExprRefs = op.getExpressions();
        List assignedVars = op.getVariables();
        for (int index = 0; index < assignedVars.size(); ++index) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)assignedExprRefs.get(index)).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            VariableReferenceExpression varExpr = (VariableReferenceExpression)expr;
            LogicalVariable sourceVar = varExpr.getVariableReference();
            this.updateInputToOutputVarMapping(sourceVar, (LogicalVariable)assignedVars.get(index), false);
        }
        return op;
    }

    public ILogicalOperator visitSelectOperator(SelectOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitDelegateOperator(DelegateOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitProjectOperator(ProjectOperator op, Void arg) throws AlgebricksException {
        this.visitSingleInputOperator((ILogicalOperator)op);
        for (LogicalVariable keyVar : this.correlatedKeyVars) {
            if (op.getVariables().contains(keyVar)) continue;
            op.getVariables().add(keyVar);
        }
        return op;
    }

    public ILogicalOperator visitReplicateOperator(ReplicateOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitSplitOperator(SplitOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitMaterializeOperator(MaterializeOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitScriptOperator(ScriptOperator op, Void arg) throws AlgebricksException {
        throw new UnsupportedOperationException("Script operators in a subplan are not supported!");
    }

    public ILogicalOperator visitSubplanOperator(SubplanOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitUnionOperator(UnionAllOperator op, Void arg) throws AlgebricksException {
        this.visitMultiInputOperator((ILogicalOperator)op);
        List varTriples = op.getVariableMappings();
        for (Triple triple : varTriples) {
            this.updateInputToOutputVarMapping((LogicalVariable)triple.first, (LogicalVariable)triple.third, false);
            this.updateInputToOutputVarMapping((LogicalVariable)triple.second, (LogicalVariable)triple.third, false);
        }
        return op;
    }

    public ILogicalOperator visitIntersectOperator(IntersectOperator op, Void arg) throws AlgebricksException {
        this.visitMultiInputOperator((ILogicalOperator)op);
        List outputVars = op.getOutputVars();
        for (int i = 0; i < op.getNumInput(); ++i) {
            List inputVars = op.getInputVariables(i);
            if (inputVars.size() != outputVars.size()) {
                throw new CompilationException(1079, op.getSourceLocation(), new Serializable[]{"The cardinality of input and output are not equal for Intersection"});
            }
            for (int j = 0; j < inputVars.size(); ++j) {
                this.updateInputToOutputVarMapping((LogicalVariable)inputVars.get(j), (LogicalVariable)outputVars.get(j), false);
            }
        }
        return op;
    }

    public ILogicalOperator visitUnnestOperator(UnnestOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitUnnestMapOperator(UnnestMapOperator op, Void arg) throws AlgebricksException {
        this.visitSingleInputOperator((ILogicalOperator)op);
        HashSet liveVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)op, liveVars);
        if (!liveVars.containsAll(this.correlatedKeyVars)) {
            op.setPropagatesInput(true);
        }
        return op;
    }

    public ILogicalOperator visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void arg) throws AlgebricksException {
        throw new CompilationException(1079, op.getSourceLocation(), new Serializable[]{"The subquery de-correlation rule should always be applied before index-access-method related rules."});
    }

    public ILogicalOperator visitDataScanOperator(DataSourceScanOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitDistinctOperator(DistinctOperator op, Void arg) throws AlgebricksException {
        this.visitSingleInputOperator((ILogicalOperator)op);
        List distinctVarList = op.getDistinctByVarList();
        for (LogicalVariable keyVar : this.correlatedKeyVars) {
            if (distinctVarList.contains(keyVar)) continue;
            distinctVarList.add(keyVar);
        }
        this.context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
        return op;
    }

    public ILogicalOperator visitExchangeOperator(ExchangeOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitTokenizeOperator(TokenizeOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    private ILogicalOperator visitAggregateOperator(ILogicalOperator op) throws AlgebricksException {
        this.visitSingleInputOperator(op);
        if (this.correlatedKeyVars.isEmpty()) {
            return op;
        }
        SourceLocation sourceLoc = op.getSourceLocation();
        GroupByOperator gbyOp = new GroupByOperator();
        gbyOp.setSourceLocation(sourceLoc);
        ArrayList<LogicalVariable> copyOfCorrelatedKeyVars = new ArrayList<LogicalVariable>(this.correlatedKeyVars);
        for (LogicalVariable keyVar : copyOfCorrelatedKeyVars) {
            LogicalVariable newVar = this.context.newVar();
            VariableReferenceExpression keyVarRef = new VariableReferenceExpression(keyVar);
            keyVarRef.setSourceLocation(sourceLoc);
            gbyOp.getGroupByList().add(new Pair((Object)newVar, (Object)new MutableObject((Object)keyVarRef)));
            this.updateInputToOutputVarMapping(keyVar, newVar, false);
        }
        ILogicalOperator inputOp = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        gbyOp.getInputs().add(new MutableObject((Object)inputOp));
        NestedTupleSourceOperator nts = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)gbyOp));
        nts.setSourceLocation(sourceLoc);
        op.getInputs().clear();
        op.getInputs().add(new MutableObject((Object)nts));
        ALogicalPlanImpl nestedPlan = new ALogicalPlanImpl();
        nestedPlan.getRoots().add(new MutableObject((Object)op));
        gbyOp.getNestedPlans().add(nestedPlan);
        OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)gbyOp, (ITypingContext)this.context);
        return op;
    }

    private ILogicalOperator visitMultiInputOperator(ILogicalOperator op) throws AlgebricksException {
        this.orderingExprs.clear();
        HashSet<LogicalVariable> keyVarsForCurrentBranch = new HashSet<LogicalVariable>();
        for (int i = op.getInputs().size() - 1; i >= 0; --i) {
            keyVarsForCurrentBranch.addAll(this.correlatedKeyVars);
            this.correlatedKeyVars.clear();
            ILogicalOperator newChild = (ILogicalOperator)((ILogicalOperator)((Mutable)op.getInputs().get(i)).getValue()).accept((ILogicalOperatorVisitor)this, null);
            ((Mutable)op.getInputs().get(i)).setValue((Object)newChild);
            if (this.correlatedKeyVars.isEmpty()) {
                this.correlatedKeyVars.addAll(keyVarsForCurrentBranch);
            }
            keyVarsForCurrentBranch.clear();
        }
        this.subtituteVariables(op);
        return op;
    }

    private ILogicalOperator visitSingleInputOperator(ILogicalOperator op) throws AlgebricksException {
        if (op.getInputs().size() == 1) {
            ILogicalOperator newChild = (ILogicalOperator)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).accept((ILogicalOperatorVisitor)this, null);
            ((Mutable)op.getInputs().get(0)).setValue((Object)newChild);
        }
        this.subtituteVariables(op);
        return op;
    }

    private void subtituteVariables(ILogicalOperator op) throws AlgebricksException {
        VariableUtilities.substituteVariables((ILogicalOperator)op, this.subplanInputVarToCurrentVarMap, (ITypingContext)this.context);
        VariableUtilities.substituteVariables((ILogicalOperator)op, this.varMapIntroducedByRewriting, (ITypingContext)this.context);
    }

    private void updateInputToOutputVarMapping(LogicalVariable oldVar, LogicalVariable newVar, boolean inNts) {
        if (this.correlatedKeyVars.contains(oldVar)) {
            this.correlatedKeyVars.remove(oldVar);
            this.correlatedKeyVars.add(newVar);
        }
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> orderExpr : this.orderingExprs) {
            ((ILogicalExpression)((Mutable)orderExpr.second).getValue()).substituteVar(oldVar, newVar);
        }
        if (this.currentVarToSubplanInputVarMap.containsKey(oldVar)) {
            oldVar = this.currentVarToSubplanInputVarMap.get(oldVar);
        }
        if (this.subplanInputVarToCurrentVarMap.containsKey(oldVar) || inNts) {
            this.subplanInputVarToCurrentVarMap.put(oldVar, newVar);
            this.currentVarToSubplanInputVarMap.put(newVar, oldVar);
        } else {
            this.varMapIntroducedByRewriting.add((Pair<LogicalVariable, LogicalVariable>)new Pair((Object)oldVar, (Object)newVar));
        }
    }

    private List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> cloneOrderingExpression(List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExprs) {
        ArrayList<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> clonedOrderExprs = new ArrayList<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>>();
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> orderExpr : orderExprs) {
            clonedOrderExprs.add((Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>)new Pair(orderExpr.first, (Object)new MutableObject((Object)((ILogicalExpression)((Mutable)orderExpr.second).getValue()).cloneExpression())));
        }
        return clonedOrderExprs;
    }

    private void addPrimaryKeys(Map<LogicalVariable, LogicalVariable> varMap) {
        for (Map.Entry<LogicalVariable, LogicalVariable> entry : varMap.entrySet()) {
            List dependencyVars = this.context.findPrimaryKey(entry.getKey());
            if (dependencyVars == null) continue;
            ArrayList<LogicalVariable> newDependencies = new ArrayList<LogicalVariable>();
            for (LogicalVariable dependencyVar : dependencyVars) {
                LogicalVariable newDependencyVar = varMap.get(dependencyVar);
                if (newDependencyVar == null) continue;
                newDependencies.add(newDependencyVar);
            }
            this.context.addPrimaryKey(new FunctionalDependency(newDependencies, Collections.singletonList(entry.getValue())));
        }
    }
}

