/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.optimizer.rules.am.AbstractIntroduceAccessMethodRule;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.asterix.optimizer.rules.am.BTreeAccessMethod;
import org.apache.asterix.optimizer.rules.am.IAccessMethod;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.InvertedIndexAccessMethod;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.asterix.optimizer.rules.am.RTreeAccessMethod;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceJoinAccessMethodRule
extends AbstractIntroduceAccessMethodRule {
    protected Mutable<ILogicalOperator> joinRef = null;
    protected AbstractBinaryJoinOperator joinOp = null;
    protected AbstractFunctionCallExpression joinCond = null;
    protected final OptimizableOperatorSubTree leftSubTree = new OptimizableOperatorSubTree();
    protected final OptimizableOperatorSubTree rightSubTree = new OptimizableOperatorSubTree();
    protected IVariableTypeEnvironment typeEnvironment = null;
    protected boolean hasGroupBy = true;
    protected List<Mutable<ILogicalOperator>> afterJoinRefs = null;
    protected static Map<FunctionIdentifier, List<IAccessMethod>> accessMethods = new HashMap<FunctionIdentifier, List<IAccessMethod>>();

    @Override
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        this.clear();
        this.setMetadataDeclarations(context);
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        if (op.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT && op.getOperatorTag() != LogicalOperatorTag.SINK && op.getOperatorTag() != LogicalOperatorTag.DELEGATE_OPERATOR) {
            return false;
        }
        this.afterJoinRefs = new ArrayList<Mutable<ILogicalOperator>>();
        boolean planTransformed = this.checkAndApplyJoinTransformation(opRef, context);
        if (this.joinOp != null) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.joinOp);
        }
        if (!planTransformed) {
            return false;
        }
        OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
        return planTransformed;
    }

    protected void pruneIndexCandidatesFromOuterBranch(Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs) {
        String innerDataset = null;
        if (this.rightSubTree.getDataset() != null) {
            innerDataset = this.rightSubTree.getDataset().getDatasetName();
        }
        for (Map.Entry<IAccessMethod, AccessMethodAnalysisContext> entry : analyzedAMs.entrySet()) {
            AccessMethodAnalysisContext amCtx = entry.getValue();
            Iterator<Map.Entry<Index, List<Pair<Integer, Integer>>>> indexIt = amCtx.getIteratorForIndexExprsAndVars();
            while (indexIt.hasNext()) {
                Map.Entry<Index, List<Pair<Integer, Integer>>> indexExprAndVarEntry = indexIt.next();
                Iterator<Pair<Integer, Integer>> exprsAndVarIter = indexExprAndVarEntry.getValue().iterator();
                boolean indexFromInnerBranch = false;
                while (exprsAndVarIter.hasNext()) {
                    Pair<Integer, Integer> exprAndVarIdx = exprsAndVarIter.next();
                    IOptimizableFuncExpr optFuncExpr = amCtx.getMatchedFuncExpr((Integer)exprAndVarIdx.first);
                    if (!indexExprAndVarEntry.getKey().getDatasetName().equals(innerDataset) || !optFuncExpr.getOperatorSubTree((Integer)exprAndVarIdx.second).equals(this.rightSubTree)) continue;
                    indexFromInnerBranch = true;
                }
                if (indexFromInnerBranch) continue;
                indexIt.remove();
            }
        }
    }

    private boolean isLeftOuterJoin(AbstractLogicalOperator op1) {
        if (op1.getInputs().size() != 1) {
            return false;
        }
        if (((ILogicalOperator)((Mutable)op1.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) {
            return false;
        }
        if (op1.getOperatorTag() == LogicalOperatorTag.GROUP) {
            return true;
        }
        this.hasGroupBy = false;
        return true;
    }

    private boolean isInnerJoin(AbstractLogicalOperator op1) {
        return op1.getOperatorTag() == LogicalOperatorTag.INNERJOIN;
    }

    @Override
    public Map<FunctionIdentifier, List<IAccessMethod>> getAccessMethods() {
        return accessMethods;
    }

    private void clear() {
        this.joinRef = null;
        this.joinOp = null;
        this.joinCond = null;
        this.afterJoinRefs = null;
    }

    protected boolean checkAndApplyJoinTransformation(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        this.afterJoinRefs.add(opRef);
        for (Mutable inputOpRef : op.getInputs()) {
            boolean joinFoundAndOptimizationApplied = this.checkAndApplyJoinTransformation((Mutable<ILogicalOperator>)inputOpRef, context);
            if (!joinFoundAndOptimizationApplied) continue;
            return true;
        }
        boolean isThisOpInnerJoin = this.isInnerJoin(op);
        boolean isThisOpLeftOuterJoin = this.isLeftOuterJoin(op);
        boolean isParentOpGroupBy = this.hasGroupBy;
        Mutable joinRefFromThisOp = null;
        InnerJoinOperator joinOpFromThisOp = null;
        Mutable opRefRemove = opRef;
        if (isThisOpInnerJoin) {
            this.joinRef = opRef;
            this.joinOp = (InnerJoinOperator)op;
            joinRefFromThisOp = opRef;
            joinOpFromThisOp = (InnerJoinOperator)op;
        } else if (isThisOpLeftOuterJoin) {
            this.joinRef = (Mutable)op.getInputs().get(0);
            this.joinOp = (LeftOuterJoinOperator)this.joinRef.getValue();
            joinRefFromThisOp = (Mutable)op.getInputs().get(0);
            joinOpFromThisOp = (LeftOuterJoinOperator)joinRefFromThisOp.getValue();
            opRefRemove = (Mutable)op.getInputs().get(0);
        }
        this.afterJoinRefs.remove(opRefRemove);
        if (isThisOpInnerJoin || isThisOpLeftOuterJoin) {
            this.joinRef = joinRefFromThisOp;
            this.joinOp = joinOpFromThisOp;
            boolean continueCheck = true;
            if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.joinOp)) {
                continueCheck = false;
            }
            HashMap<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs = null;
            if (continueCheck) {
                analyzedAMs = new HashMap<IAccessMethod, AccessMethodAnalysisContext>();
            }
            if (continueCheck && !this.checkJoinOpConditionAndInitSubTree(context)) {
                continueCheck = false;
            }
            boolean matchInLeftSubTree = false;
            boolean matchInRightSubTree = false;
            if (continueCheck) {
                if (this.leftSubTree.hasDataSource()) {
                    matchInLeftSubTree = this.analyzeSelectOrJoinOpConditionAndUpdateAnalyzedAM((ILogicalExpression)this.joinCond, this.leftSubTree.getAssignsAndUnnests(), analyzedAMs, context, this.typeEnvironment);
                }
                if (this.rightSubTree.hasDataSource()) {
                    matchInRightSubTree = this.analyzeSelectOrJoinOpConditionAndUpdateAnalyzedAM((ILogicalExpression)this.joinCond, this.rightSubTree.getAssignsAndUnnests(), analyzedAMs, context, this.typeEnvironment);
                }
            }
            boolean checkLeftSubTreeMetadata = false;
            boolean checkRightSubTreeMetadata = false;
            if (continueCheck && matchInRightSubTree) {
                if (matchInLeftSubTree) {
                    checkLeftSubTreeMetadata = this.leftSubTree.setDatasetAndTypeMetadata(this.metadataProvider);
                }
                checkRightSubTreeMetadata = this.rightSubTree.setDatasetAndTypeMetadata(this.metadataProvider);
            }
            if (continueCheck && checkRightSubTreeMetadata) {
                if (checkLeftSubTreeMetadata) {
                    this.fillSubTreeIndexExprs(this.leftSubTree, analyzedAMs, context);
                } else {
                    this.fillSubTreeIndexExprs(this.leftSubTree, analyzedAMs, context, true);
                }
                this.fillSubTreeIndexExprs(this.rightSubTree, analyzedAMs, context);
                this.pruneIndexCandidates(analyzedAMs, context, this.typeEnvironment);
                this.pruneIndexCandidatesFromOuterBranch(analyzedAMs);
                Pair<IAccessMethod, Index> chosenIndex = this.chooseBestIndex(analyzedAMs);
                if (chosenIndex == null) {
                    context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.joinOp);
                    continueCheck = false;
                }
                if (continueCheck) {
                    if (checkLeftSubTreeMetadata) {
                        this.fillFieldNamesInTheSubTree(this.leftSubTree);
                    }
                    if (checkRightSubTreeMetadata) {
                        this.fillFieldNamesInTheSubTree(this.rightSubTree);
                    }
                    AccessMethodAnalysisContext analysisCtx = (AccessMethodAnalysisContext)analyzedAMs.get(chosenIndex.first);
                    if (isThisOpLeftOuterJoin && isParentOpGroupBy) {
                        analysisCtx.setLOJGroupbyOpRef((Mutable<ILogicalOperator>)opRef);
                        ScalarFunctionCallExpression isNullFuncExpr = AccessMethodUtils.findLOJIsMissingFuncInGroupBy((GroupByOperator)opRef.getValue(), this.rightSubTree);
                        analysisCtx.setLOJIsMissingFuncInGroupBy(isNullFuncExpr);
                    }
                    Dataset indexDataset = analysisCtx.getDatasetFromIndexDatasetMap((Index)chosenIndex.second);
                    if (!this.rightSubTree.hasDataSourceScan() && !indexDataset.getDatasetName().equals(this.rightSubTree.getDataset().getDatasetName())) {
                        return false;
                    }
                    boolean res = ((IAccessMethod)chosenIndex.first).applyJoinPlanTransformation(this.afterJoinRefs, this.joinRef, this.leftSubTree, this.rightSubTree, (Index)chosenIndex.second, analysisCtx, context, isThisOpLeftOuterJoin, isParentOpGroupBy);
                    if (res) {
                        return res;
                    }
                }
            }
            this.joinRef = null;
            this.joinOp = null;
        }
        if (isThisOpLeftOuterJoin) {
            this.afterJoinRefs.remove(opRef);
        }
        return false;
    }

    protected boolean checkJoinOpConditionAndInitSubTree(IOptimizationContext context) throws AlgebricksException {
        this.typeEnvironment = context.getOutputTypeEnvironment((ILogicalOperator)this.joinOp);
        ILogicalExpression condExpr = (ILogicalExpression)this.joinOp.getCondition().getValue();
        if (condExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        this.joinCond = (AbstractFunctionCallExpression)condExpr;
        this.leftSubTree.initFromSubTree((Mutable<ILogicalOperator>)((Mutable)this.joinOp.getInputs().get(0)));
        boolean rightSubTreeInitialized = this.rightSubTree.initFromSubTree((Mutable<ILogicalOperator>)((Mutable)this.joinOp.getInputs().get(1)));
        if (!rightSubTreeInitialized) {
            return false;
        }
        return this.rightSubTree.hasDataSourceScan();
    }

    static {
        IntroduceJoinAccessMethodRule.registerAccessMethod(BTreeAccessMethod.INSTANCE, accessMethods);
        IntroduceJoinAccessMethodRule.registerAccessMethod(RTreeAccessMethod.INSTANCE, accessMethods);
        IntroduceJoinAccessMethodRule.registerAccessMethod(InvertedIndexAccessMethod.INSTANCE, accessMethods);
    }
}

