/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;

public class AccessMethodJobGenParams {
    private static final int NUM_PARAMS = 6;
    protected String indexName;
    protected DatasetConfig.IndexType indexType;
    protected String dataverseName;
    protected String datasetName;
    protected boolean retainInput;
    protected boolean requiresBroadcast;
    protected boolean isPrimaryIndex;

    public AccessMethodJobGenParams() {
    }

    public AccessMethodJobGenParams(String indexName, DatasetConfig.IndexType indexType, String dataverseName, String datasetName, boolean retainInput, boolean requiresBroadcast) {
        this.indexName = indexName;
        this.indexType = indexType;
        this.dataverseName = dataverseName;
        this.datasetName = datasetName;
        this.retainInput = retainInput;
        this.requiresBroadcast = requiresBroadcast;
        this.isPrimaryIndex = datasetName.equals(indexName);
    }

    public void writeToFuncArgs(List<Mutable<ILogicalExpression>> funcArgs) {
        funcArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)AccessMethodUtils.createStringConstant(this.indexName)));
        funcArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)AccessMethodUtils.createInt32Constant(this.indexType.ordinal())));
        funcArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)AccessMethodUtils.createStringConstant(this.dataverseName)));
        funcArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)AccessMethodUtils.createStringConstant(this.datasetName)));
        funcArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)AccessMethodUtils.createBooleanConstant(this.retainInput)));
        funcArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)AccessMethodUtils.createBooleanConstant(this.requiresBroadcast)));
    }

    public void readFromFuncArgs(List<Mutable<ILogicalExpression>> funcArgs) {
        this.indexName = AccessMethodUtils.getStringConstant(funcArgs.get(0));
        this.indexType = DatasetConfig.IndexType.values()[AccessMethodUtils.getInt32Constant(funcArgs.get(1))];
        this.dataverseName = AccessMethodUtils.getStringConstant(funcArgs.get(2));
        this.datasetName = AccessMethodUtils.getStringConstant(funcArgs.get(3));
        this.retainInput = AccessMethodUtils.getBooleanConstant(funcArgs.get(4));
        this.requiresBroadcast = AccessMethodUtils.getBooleanConstant(funcArgs.get(5));
        this.isPrimaryIndex = this.datasetName.equals(this.indexName);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public DatasetConfig.IndexType getIndexType() {
        return this.indexType;
    }

    public String getDataverseName() {
        return this.dataverseName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public boolean getRetainInput() {
        return this.retainInput;
    }

    public boolean getRequiresBroadcast() {
        return this.requiresBroadcast;
    }

    protected void writeVarList(List<LogicalVariable> varList, List<Mutable<ILogicalExpression>> funcArgs) {
        MutableObject numKeysRef = new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(varList.size()))));
        funcArgs.add((Mutable<ILogicalExpression>)numKeysRef);
        for (LogicalVariable keyVar : varList) {
            VariableReferenceExpression keyVarRef = new VariableReferenceExpression(keyVar);
            funcArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)keyVarRef));
        }
    }

    protected int readVarList(List<Mutable<ILogicalExpression>> funcArgs, int index, List<LogicalVariable> varList) {
        int numLowKeys = AccessMethodUtils.getInt32Constant(funcArgs.get(index));
        if (numLowKeys > 0) {
            for (int i = 0; i < numLowKeys; ++i) {
                LogicalVariable var = ((VariableReferenceExpression)funcArgs.get(index + 1 + i).getValue()).getVariableReference();
                varList.add(var);
            }
        }
        return index + numLowKeys + 1;
    }

    protected int getNumParams() {
        return 6;
    }

    public boolean isPrimaryIndex() {
        return this.isPrimaryIndex;
    }
}

