/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.algebra.operators.physical.BTreeSearchPOperator;
import org.apache.asterix.algebra.operators.physical.InvertedIndexPOperator;
import org.apache.asterix.algebra.operators.physical.RTreeSearchPOperator;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.am.AccessMethodJobGenParams;
import org.apache.asterix.optimizer.rules.am.BTreeJobGenParams;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.ExternalGroupByPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.PreclusteredGroupByPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.algebricks.rewriter.util.JoinUtils;

public class SetAsterixPhysicalOperatorsRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        SetAsterixPhysicalOperatorsRule.computeDefaultPhysicalOp(op, true, context);
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        return true;
    }

    private static void setPhysicalOperators(ILogicalPlan plan, boolean topLevelOp, IOptimizationContext context) throws AlgebricksException {
        for (Mutable root : plan.getRoots()) {
            SetAsterixPhysicalOperatorsRule.computeDefaultPhysicalOp((AbstractLogicalOperator)root.getValue(), topLevelOp, context);
        }
    }

    private static void computeDefaultPhysicalOp(AbstractLogicalOperator op, boolean topLevelOp, IOptimizationContext context) throws AlgebricksException {
        ILogicalPlan p0;
        GroupByOperator gby;
        PhysicalOptimizationConfig physicalOptimizationConfig = context.getPhysicalOptimizationConfig();
        if (op.getOperatorTag().equals((Object)LogicalOperatorTag.GROUP) && (gby = (GroupByOperator)op).getNestedPlans().size() == 1 && (p0 = (ILogicalPlan)gby.getNestedPlans().get(0)).getRoots().size() == 1) {
            AbstractFunctionCallExpression expr;
            Mutable r0 = (Mutable)p0.getRoots().get(0);
            if (((ILogicalOperator)r0.getValue()).getOperatorTag().equals((Object)LogicalOperatorTag.AGGREGATE)) {
                AggregateOperator aggOp = (AggregateOperator)r0.getValue();
                boolean serializable = true;
                for (Mutable exprRef : aggOp.getExpressions()) {
                    expr = (AbstractFunctionCallExpression)exprRef.getValue();
                    if (BuiltinFunctions.isAggregateFunctionSerializable((FunctionIdentifier)expr.getFunctionIdentifier())) continue;
                    serializable = false;
                    break;
                }
                if (gby.getAnnotations().get("USE_HASH_GROUP_BY") == Boolean.TRUE || gby.getAnnotations().get("USE_EXTERNAL_GROUP_BY") == Boolean.TRUE) {
                    boolean setToExternalGby = false;
                    if (serializable) {
                        boolean hasIntermediateAgg = true;
                        IMergeAggregationExpressionFactory mergeAggregationExpressionFactory = context.getMergeAggregationExpressionFactory();
                        List originalVariables = aggOp.getVariables();
                        List aggExprs = aggOp.getExpressions();
                        int aggNum = aggExprs.size();
                        for (int i = 0; i < aggNum; ++i) {
                            AbstractFunctionCallExpression expr2 = (AbstractFunctionCallExpression)((Mutable)aggExprs.get(i)).getValue();
                            AggregateFunctionCallExpression serialAggExpr = BuiltinFunctions.makeSerializableAggregateFunctionExpression((FunctionIdentifier)expr2.getFunctionIdentifier(), (List)expr2.getArguments());
                            serialAggExpr.setSourceLocation(expr2.getSourceLocation());
                            if (mergeAggregationExpressionFactory.createMergeAggregation((LogicalVariable)originalVariables.get(i), (ILogicalExpression)serialAggExpr, context) != null) continue;
                            hasIntermediateAgg = false;
                            break;
                        }
                        boolean multipleAggOpsFound = false;
                        AggregateOperator r1Logical = aggOp;
                        while (r1Logical.hasInputs()) {
                            if ((r1Logical = (ILogicalOperator)((Mutable)r1Logical.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.AGGREGATE) continue;
                            multipleAggOpsFound = true;
                            break;
                        }
                        if (hasIntermediateAgg && !multipleAggOpsFound) {
                            for (int i = 0; i < aggNum; ++i) {
                                AbstractFunctionCallExpression expr3 = (AbstractFunctionCallExpression)((Mutable)aggExprs.get(i)).getValue();
                                AggregateFunctionCallExpression serialAggExpr = BuiltinFunctions.makeSerializableAggregateFunctionExpression((FunctionIdentifier)expr3.getFunctionIdentifier(), (List)expr3.getArguments());
                                serialAggExpr.setSourceLocation(expr3.getSourceLocation());
                                ((Mutable)aggOp.getExpressions().get(i)).setValue((Object)serialAggExpr);
                            }
                            ExternalGroupByPOperator externalGby = new ExternalGroupByPOperator(gby.getGroupByList(), physicalOptimizationConfig.getMaxFramesForGroupBy(), (long)physicalOptimizationConfig.getMaxFramesForGroupBy() * (long)physicalOptimizationConfig.getFrameSize());
                            SetAsterixPhysicalOperatorsRule.generateMergeAggregationExpressions(gby, context);
                            op.setPhysicalOperator((IPhysicalOperator)externalGby);
                            setToExternalGby = true;
                        }
                    }
                    if (!setToExternalGby) {
                        List gbyList = gby.getGroupByList();
                        ArrayList<LogicalVariable> columnList = new ArrayList<LogicalVariable>(gbyList.size());
                        for (Pair p : gbyList) {
                            ILogicalExpression expr4 = (ILogicalExpression)((Mutable)p.second).getValue();
                            if (expr4.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
                            VariableReferenceExpression varRef = (VariableReferenceExpression)expr4;
                            columnList.add(varRef.getVariableReference());
                        }
                        op.setPhysicalOperator((IPhysicalOperator)new PreclusteredGroupByPOperator(columnList, gby.isGroupAll(), context.getPhysicalOptimizationConfig().getMaxFramesForGroupBy()));
                    }
                }
            } else if (((ILogicalOperator)r0.getValue()).getOperatorTag().equals((Object)LogicalOperatorTag.RUNNINGAGGREGATE)) {
                List gbyList = gby.getGroupByList();
                ArrayList<LogicalVariable> columnList = new ArrayList<LogicalVariable>(gbyList.size());
                for (Pair p : gbyList) {
                    expr = (ILogicalExpression)((Mutable)p.second).getValue();
                    if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
                    VariableReferenceExpression varRef = (VariableReferenceExpression)expr;
                    columnList.add(varRef.getVariableReference());
                }
                op.setPhysicalOperator((IPhysicalOperator)new PreclusteredGroupByPOperator(columnList, gby.isGroupAll(), context.getPhysicalOptimizationConfig().getMaxFramesForGroupBy()));
            } else {
                throw new CompilationException(1079, gby.getSourceLocation(), new Serializable[]{"Unsupported nested operator within a group-by: " + ((ILogicalOperator)r0.getValue()).getOperatorTag().name()});
            }
        }
        if (op.getPhysicalOperator() == null) {
            block0 : switch (op.getOperatorTag()) {
                case INNERJOIN: {
                    JoinUtils.setJoinAlgorithmAndExchangeAlgo((AbstractBinaryJoinOperator)((InnerJoinOperator)op), (boolean)topLevelOp, (IOptimizationContext)context);
                    break;
                }
                case LEFTOUTERJOIN: {
                    JoinUtils.setJoinAlgorithmAndExchangeAlgo((AbstractBinaryJoinOperator)((LeftOuterJoinOperator)op), (boolean)topLevelOp, (IOptimizationContext)context);
                    break;
                }
                case UNNEST_MAP: 
                case LEFT_OUTER_UNNEST_MAP: {
                    ILogicalExpression unnestExpr = null;
                    unnestExpr = (ILogicalExpression)((AbstractUnnestMapOperator)op).getExpressionRef().getValue();
                    if (unnestExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) break;
                    AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)unnestExpr;
                    FunctionIdentifier fid = f.getFunctionIdentifier();
                    if (!fid.equals((Object)BuiltinFunctions.INDEX_SEARCH)) {
                        throw new IllegalStateException();
                    }
                    AccessMethodJobGenParams jobGenParams = new AccessMethodJobGenParams();
                    jobGenParams.readFromFuncArgs(f.getArguments());
                    MetadataProvider mp = (MetadataProvider)context.getMetadataProvider();
                    DataSourceId dataSourceId = new DataSourceId(jobGenParams.getDataverseName(), jobGenParams.getDatasetName());
                    Dataset dataset = mp.findDataset(jobGenParams.getDataverseName(), jobGenParams.getDatasetName());
                    IDataSourceIndex dsi = mp.findDataSourceIndex(jobGenParams.getIndexName(), dataSourceId);
                    INodeDomain storageDomain = mp.findNodeDomain(dataset.getNodeGroupName());
                    if (dsi == null) {
                        throw new CompilationException(1079, op.getSourceLocation(), new Serializable[]{"Could not find index " + jobGenParams.getIndexName() + " for dataset " + dataSourceId});
                    }
                    DatasetConfig.IndexType indexType = jobGenParams.getIndexType();
                    boolean requiresBroadcast = jobGenParams.getRequiresBroadcast();
                    switch (indexType) {
                        case BTREE: {
                            BTreeJobGenParams btreeJobGenParams = new BTreeJobGenParams();
                            btreeJobGenParams.readFromFuncArgs(f.getArguments());
                            op.setPhysicalOperator((IPhysicalOperator)new BTreeSearchPOperator((IDataSourceIndex<String, DataSourceId>)dsi, storageDomain, requiresBroadcast, btreeJobGenParams.isPrimaryIndex(), btreeJobGenParams.isEqCondition(), btreeJobGenParams.getLowKeyVarList(), btreeJobGenParams.getHighKeyVarList()));
                            break block0;
                        }
                        case RTREE: {
                            op.setPhysicalOperator((IPhysicalOperator)new RTreeSearchPOperator((IDataSourceIndex<String, DataSourceId>)dsi, storageDomain, requiresBroadcast));
                            break block0;
                        }
                        case SINGLE_PARTITION_WORD_INVIX: 
                        case SINGLE_PARTITION_NGRAM_INVIX: {
                            op.setPhysicalOperator((IPhysicalOperator)new InvertedIndexPOperator((IDataSourceIndex<String, DataSourceId>)dsi, storageDomain, requiresBroadcast, false));
                            break block0;
                        }
                        case LENGTH_PARTITIONED_WORD_INVIX: 
                        case LENGTH_PARTITIONED_NGRAM_INVIX: {
                            op.setPhysicalOperator((IPhysicalOperator)new InvertedIndexPOperator((IDataSourceIndex<String, DataSourceId>)dsi, storageDomain, requiresBroadcast, true));
                            break block0;
                        }
                    }
                    throw new NotImplementedException(indexType + " indexes are not implemented.");
                }
            }
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans nested = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : nested.getNestedPlans()) {
                SetAsterixPhysicalOperatorsRule.setPhysicalOperators(p, false, context);
            }
        }
        for (Mutable opRef : op.getInputs()) {
            SetAsterixPhysicalOperatorsRule.computeDefaultPhysicalOp((AbstractLogicalOperator)opRef.getValue(), topLevelOp, context);
        }
    }

    private static void generateMergeAggregationExpressions(GroupByOperator gby, IOptimizationContext context) throws AlgebricksException {
        if (gby.getNestedPlans().size() != 1) {
            throw new CompilationException(1079, gby.getSourceLocation(), new Serializable[]{"External group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source."});
        }
        ILogicalPlan p0 = (ILogicalPlan)gby.getNestedPlans().get(0);
        if (p0.getRoots().size() != 1) {
            throw new CompilationException(1079, gby.getSourceLocation(), new Serializable[]{"External group-by currently works only for one nested plan with one root containingan aggregate and a nested-tuple-source."});
        }
        IMergeAggregationExpressionFactory mergeAggregationExpressionFactory = context.getMergeAggregationExpressionFactory();
        Mutable r0 = (Mutable)p0.getRoots().get(0);
        AbstractLogicalOperator r0Logical = (AbstractLogicalOperator)r0.getValue();
        if (r0Logical.getOperatorTag() != LogicalOperatorTag.AGGREGATE) {
            throw new CompilationException(1079, gby.getSourceLocation(), new Serializable[]{"The merge aggregation expression generation should not process a " + r0Logical.getOperatorTag() + " operator."});
        }
        AggregateOperator aggOp = (AggregateOperator)r0.getValue();
        List aggFuncRefs = aggOp.getExpressions();
        List aggProducedVars = aggOp.getVariables();
        int n = aggOp.getExpressions().size();
        ArrayList<MutableObject> mergeExpressionRefs = new ArrayList<MutableObject>();
        for (int i = 0; i < n; ++i) {
            ILogicalExpression aggFuncExpr = (ILogicalExpression)((Mutable)aggFuncRefs.get(i)).getValue();
            ILogicalExpression mergeExpr = mergeAggregationExpressionFactory.createMergeAggregation((LogicalVariable)aggProducedVars.get(i), aggFuncExpr, context);
            if (mergeExpr == null) {
                throw new CompilationException(1079, aggFuncExpr.getSourceLocation(), new Serializable[]{"The aggregation function " + aggFuncExpr + " does not have a registered intermediate aggregation function."});
            }
            mergeExpressionRefs.add(new MutableObject((Object)mergeExpr));
        }
        aggOp.setMergeExpressions(mergeExpressionRefs);
    }
}

