/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.ILogicalExpressionReferenceTransformWithCondition;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;

class LogicalExpressionReferenceTransform
implements ILogicalExpressionReferenceTransformWithCondition {
    private final LogicalVariable dataVar;
    private final LogicalVariable metaVar;
    private boolean variableRequired = false;

    LogicalExpressionReferenceTransform(LogicalVariable dataVar, LogicalVariable metaVar) {
        this.dataVar = dataVar;
        this.metaVar = metaVar;
    }

    @Override
    public void setVariableRequired() {
        this.variableRequired = true;
    }

    public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        List argRefs = funcExpr.getArguments();
        for (Mutable argRef : argRefs) {
            this.transform((Mutable<ILogicalExpression>)argRef);
        }
        if (!funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.META)) {
            return false;
        }
        if (argRefs.size() > 1) {
            throw new CompilationException(1079, expr.getSourceLocation(), new Serializable[]{"The meta function can at most have one argument!"});
        }
        if (argRefs.size() == 1) {
            ILogicalExpression argExpr = (ILogicalExpression)((Mutable)argRefs.get(0)).getValue();
            if (argExpr.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                return false;
            }
            VariableReferenceExpression argVarExpr = (VariableReferenceExpression)argExpr;
            LogicalVariable argVar = argVarExpr.getVariableReference();
            if (!this.dataVar.equals((Object)argVar)) {
                return false;
            }
            VariableReferenceExpression metaVarRef = new VariableReferenceExpression(this.metaVar);
            metaVarRef.setSourceLocation(expr.getSourceLocation());
            exprRef.setValue((Object)metaVarRef);
            return true;
        }
        if (this.variableRequired) {
            throw new CompilationException(1079, expr.getSourceLocation(), new Serializable[]{"Cannot resolve to ambiguity on the meta function call -- there are more than one dataset choices!"});
        }
        VariableReferenceExpression metaVarRef = new VariableReferenceExpression(this.metaVar);
        metaVarRef.setSourceLocation(expr.getSourceLocation());
        exprRef.setValue((Object)metaVarRef);
        return true;
    }
}

