/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.base.AnalysisUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class LoadRecordFieldsRule
implements IAlgebraicRewriteRule {
    private ExtractFieldLoadExpressionVisitor exprVisitor = new ExtractFieldLoadExpressionVisitor();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AssignOperator a1;
        ILogicalExpression expr;
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1)) {
            return false;
        }
        if (op1.getOperatorTag() == LogicalOperatorTag.ASSIGN && AnalysisUtil.isAccessToFieldRecord(expr = LoadRecordFieldsRule.getFirstExpr(a1 = (AssignOperator)op1))) {
            boolean res = LoadRecordFieldsRule.findAndEliminateRedundantFieldAccess(a1, context);
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1);
            return res;
        }
        this.exprVisitor.setTopOp(op1);
        this.exprVisitor.setContext(context);
        boolean res = op1.acceptExpressionTransform((ILogicalExpressionReferenceTransform)this.exprVisitor);
        if (!res) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1);
        }
        if (res && op1.getOperatorTag() == LogicalOperatorTag.SELECT) {
            AssignOperator assign1;
            AbstractLogicalExpression expr1;
            SelectOperator sigma = (SelectOperator)op1;
            LinkedList vars = new LinkedList();
            VariableUtilities.getUsedVariables((ILogicalOperator)sigma, vars);
            if (vars.size() == 1 && (expr1 = (AbstractLogicalExpression)LoadRecordFieldsRule.getFirstExpr(assign1 = (AssignOperator)((Mutable)op1.getInputs().get(0)).getValue())).getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expr1;
                sigma.getAnnotations().put("FIELD_ACCESS", f.getArguments().get(0));
            }
        }
        if (res) {
            OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
        }
        return res;
    }

    private static boolean pushFieldLoads(Mutable<ILogicalExpression> exprRef, AbstractLogicalOperator topOp, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr == null) {
            return false;
        }
        switch (expr.getExpressionTag()) {
            case FUNCTION_CALL: {
                AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expr;
                FunctionIdentifier fi = f.getFunctionIdentifier();
                if (AlgebricksBuiltinFunctions.isComparisonFunction((FunctionIdentifier)fi)) {
                    boolean b1 = LoadRecordFieldsRule.pushFieldLoads((Mutable<ILogicalExpression>)((Mutable)f.getArguments().get(0)), topOp, context);
                    boolean b2 = LoadRecordFieldsRule.pushFieldLoads((Mutable<ILogicalExpression>)((Mutable)f.getArguments().get(1)), topOp, context);
                    return b1 || b2;
                }
                if (fi.equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME)) {
                    VariableReferenceExpression ref;
                    LogicalVariable var;
                    List keys;
                    if (AnalysisUtil.numberOfVarsInExpr((ILogicalExpression)f) == 0) {
                        return false;
                    }
                    LogicalVariable v = context.newVar();
                    AssignOperator a2 = new AssignOperator(v, (Mutable)new MutableObject((Object)f));
                    a2.setSourceLocation(expr.getSourceLocation());
                    LoadRecordFieldsRule.pushFieldAssign(a2, topOp, context);
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)a2);
                    ILogicalExpression arg = (ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue();
                    if (arg.getExpressionTag() == LogicalExpressionTag.VARIABLE && (keys = context.findPrimaryKey(var = (ref = (VariableReferenceExpression)arg).getVariableReference())) != null) {
                        ArrayList<LogicalVariable> tail = new ArrayList<LogicalVariable>();
                        tail.add(v);
                        FunctionalDependency pk = new FunctionalDependency(keys, tail);
                        context.addPrimaryKey(pk);
                    }
                    VariableReferenceExpression varRef = new VariableReferenceExpression(v);
                    varRef.setSourceLocation(expr.getSourceLocation());
                    exprRef.setValue((Object)varRef);
                    return true;
                }
                boolean pushed = false;
                for (Mutable argRef : f.getArguments()) {
                    if (!LoadRecordFieldsRule.pushFieldLoads((Mutable<ILogicalExpression>)argRef, topOp, context)) continue;
                    pushed = true;
                }
                return pushed;
            }
            case CONSTANT: 
            case VARIABLE: {
                return false;
            }
        }
        assert (false);
        throw new IllegalArgumentException();
    }

    private static void pushFieldAssign(AssignOperator a2, AbstractLogicalOperator topOp, IOptimizationContext context) throws AlgebricksException {
        if (topOp.getInputs().size() == 1 && !topOp.hasNestedPlans()) {
            Mutable topChild = (Mutable)topOp.getInputs().get(0);
            List a2InptList = a2.getInputs();
            a2InptList.clear();
            a2InptList.add(topChild);
            topOp.getInputs().set(0, new MutableObject((Object)a2));
            LoadRecordFieldsRule.findAndEliminateRedundantFieldAccess(a2, context);
        } else {
            LinkedList usedInAccess = new LinkedList();
            VariableUtilities.getUsedVariables((ILogicalOperator)a2, usedInAccess);
            LinkedList produced2 = new LinkedList();
            VariableUtilities.getProducedVariables((ILogicalOperator)topOp, produced2);
            if (OperatorPropertiesUtil.disjoint(produced2, usedInAccess)) {
                for (Mutable inp : topOp.getInputs()) {
                    HashSet v2 = new HashSet();
                    VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)inp.getValue()), v2);
                    if (OperatorPropertiesUtil.disjoint(usedInAccess, v2)) continue;
                    LoadRecordFieldsRule.pushAccessAboveOpRef(a2, (Mutable<ILogicalOperator>)inp, context);
                    return;
                }
                if (topOp.hasNestedPlans()) {
                    AbstractOperatorWithNestedPlans nestedOp = (AbstractOperatorWithNestedPlans)topOp;
                    for (ILogicalPlan plan : nestedOp.getNestedPlans()) {
                        for (Mutable root : plan.getRoots()) {
                            HashSet v2 = new HashSet();
                            VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)root.getValue()), v2);
                            if (OperatorPropertiesUtil.disjoint(usedInAccess, v2)) continue;
                            LoadRecordFieldsRule.pushAccessAboveOpRef(a2, (Mutable<ILogicalOperator>)root, context);
                            return;
                        }
                    }
                }
                throw new CompilationException(1079, a2.getSourceLocation(), new Serializable[]{"Field access " + LoadRecordFieldsRule.getFirstExpr(a2) + " does not correspond to any input of operator " + topOp});
            }
        }
    }

    private static void pushAccessAboveOpRef(AssignOperator toPush, Mutable<ILogicalOperator> toPushThroughChildRef, IOptimizationContext context) throws AlgebricksException {
        List tpInpList = toPush.getInputs();
        tpInpList.clear();
        tpInpList.add(new MutableObject(toPushThroughChildRef.getValue()));
        toPushThroughChildRef.setValue((Object)toPush);
        LoadRecordFieldsRule.findAndEliminateRedundantFieldAccess(toPush, context);
    }

    private static boolean findAndEliminateRedundantFieldAccess(AssignOperator assign, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression fldExpr;
        ILogicalExpression expr = LoadRecordFieldsRule.getFirstExpr(assign);
        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expr;
        ILogicalExpression arg0 = (ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue();
        if (arg0.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        VariableReferenceExpression vre = (VariableReferenceExpression)arg0;
        LogicalVariable recordVar = vre.getVariableReference();
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)f.getArguments().get(1)).getValue();
        if (arg1.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return false;
        }
        IVariableTypeEnvironment typeEnvironment = context.getOutputTypeEnvironment((ILogicalOperator)assign);
        ConstantExpression ce = (ConstantExpression)arg1;
        if (f.getFunctionIdentifier().equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME)) {
            String fldName = ((AString)((AsterixConstantValue)ce.getValue()).getObject()).getStringValue();
            fldExpr = LoadRecordFieldsRule.findFieldExpression((AbstractLogicalOperator)assign, recordVar, fldName, typeEnvironment, (name, expression, env) -> LoadRecordFieldsRule.findFieldByNameFromRecordConstructor(name, expression));
        } else if (f.getFunctionIdentifier().equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_INDEX)) {
            Integer fldIdx = ((AInt32)((AsterixConstantValue)ce.getValue()).getObject()).getIntegerValue();
            fldExpr = LoadRecordFieldsRule.findFieldExpression((AbstractLogicalOperator)assign, recordVar, fldIdx, typeEnvironment, LoadRecordFieldsRule::findFieldByIndexFromRecordConstructor);
        } else {
            if (f.getFunctionIdentifier().equals((Object)BuiltinFunctions.FIELD_ACCESS_NESTED)) {
                return false;
            }
            throw new IllegalStateException();
        }
        if (fldExpr == null) {
            return false;
        }
        ArrayList usedVariables = new ArrayList();
        fldExpr.getUsedVariables(usedVariables);
        ArrayList liveInputVars = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)assign, liveInputVars);
        usedVariables.removeAll(liveInputVars);
        if (usedVariables.isEmpty()) {
            ((Mutable)assign.getExpressions().get(0)).setValue((Object)fldExpr);
            return true;
        }
        return false;
    }

    private static ILogicalExpression findFieldExpression(AbstractLogicalOperator op, LogicalVariable recordVar, Object accessKey, IVariableTypeEnvironment typeEnvironment, FieldResolver resolver) throws AlgebricksException {
        for (Mutable child : op.getInputs()) {
            ILogicalExpression expr2;
            NestedTupleSourceOperator nts;
            AbstractLogicalOperator opBelowNestedPlan;
            ILogicalExpression expr1;
            AbstractLogicalOperator opChild = (AbstractLogicalOperator)child.getValue();
            if (opChild.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
                AssignOperator op2 = (AssignOperator)opChild;
                int i = op2.getVariables().indexOf(recordVar);
                if (i >= 0) {
                    AbstractLogicalExpression constr = (AbstractLogicalExpression)((Mutable)op2.getExpressions().get(i)).getValue();
                    return LoadRecordFieldsRule.resolveFieldExpression(constr, accessKey, typeEnvironment, resolver);
                }
            } else if (opChild.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE && (expr1 = LoadRecordFieldsRule.findFieldExpression(opBelowNestedPlan = (AbstractLogicalOperator)((Mutable)((ILogicalOperator)(nts = (NestedTupleSourceOperator)opChild).getDataSourceReference().getValue()).getInputs().get(0)).getValue(), recordVar, accessKey, typeEnvironment, resolver)) != null) {
                return expr1;
            }
            if ((expr2 = LoadRecordFieldsRule.findFieldExpression(opChild, recordVar, accessKey, typeEnvironment, resolver)) == null) continue;
            return expr2;
        }
        return null;
    }

    private static ILogicalExpression resolveFieldExpression(AbstractLogicalExpression constr, Object accessKey, IVariableTypeEnvironment typeEnvironment, FieldResolver resolver) throws AlgebricksException {
        if (constr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return null;
        }
        AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)constr;
        if (!fce.getFunctionIdentifier().equals((Object)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR) && !fce.getFunctionIdentifier().equals((Object)BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR)) {
            return null;
        }
        return resolver.resolve(accessKey, fce, typeEnvironment);
    }

    private static ILogicalExpression findFieldByNameFromRecordConstructor(Object fldName, AbstractFunctionCallExpression fce) {
        Iterator fldIter = fce.getArguments().iterator();
        while (fldIter.hasNext()) {
            ILogicalExpression fldExpr = (ILogicalExpression)((Mutable)fldIter.next()).getValue();
            if (fldName.equals(ConstantExpressionUtil.getStringConstant((ILogicalExpression)fldExpr))) {
                return (ILogicalExpression)((Mutable)fldIter.next()).getValue();
            }
            fldIter.next();
        }
        return null;
    }

    private static ILogicalExpression findFieldByIndexFromRecordConstructor(Object index, AbstractFunctionCallExpression fce, IVariableTypeEnvironment typeEnvironment) throws AlgebricksException {
        Integer fieldIndex = (Integer)index;
        ARecordType recordType = (ARecordType)typeEnvironment.getType((ILogicalExpression)fce);
        String[] closedFieldNames = recordType.getFieldNames();
        return closedFieldNames.length > fieldIndex ? LoadRecordFieldsRule.findFieldByNameFromRecordConstructor(closedFieldNames[fieldIndex], fce) : null;
    }

    private static ILogicalExpression getFirstExpr(AssignOperator assign) {
        return (ILogicalExpression)((Mutable)assign.getExpressions().get(0)).getValue();
    }

    private final class ExtractFieldLoadExpressionVisitor
    implements ILogicalExpressionReferenceTransform {
        private AbstractLogicalOperator topOp;
        private IOptimizationContext context;

        private ExtractFieldLoadExpressionVisitor() {
        }

        public void setTopOp(AbstractLogicalOperator topOp) {
            this.topOp = topOp;
        }

        public void setContext(IOptimizationContext context) {
            this.context = context;
        }

        public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
            return LoadRecordFieldsRule.pushFieldLoads((Mutable<ILogicalExpression>)exprRef, this.topOp, this.context);
        }
    }

    @FunctionalInterface
    private static interface FieldResolver {
        public ILogicalExpression resolve(Object var1, AbstractFunctionCallExpression var2, IVariableTypeEnvironment var3) throws AlgebricksException;
    }
}

