/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.functions.ExternalScalarFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.optimizer.rules.IntroduceDynamicTypeCastRule;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceDynamicTypeCastForExternalFunctionRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    private boolean rewriteFunctionArgs(ILogicalOperator op, Mutable<ILogicalExpression> expRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)expRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        boolean changed = false;
        AbstractFunctionCallExpression funcCallExpr = (AbstractFunctionCallExpression)expr;
        for (Mutable functionArgRef : funcCallExpr.getArguments()) {
            if (!this.rewriteFunctionArgs(op, (Mutable<ILogicalExpression>)functionArgRef, context)) continue;
            changed = true;
        }
        if (BuiltinFunctions.getBuiltinFunctionIdentifier((FunctionIdentifier)funcCallExpr.getFunctionIdentifier()) != null) {
            return changed;
        }
        for (int iter1 = 0; iter1 < funcCallExpr.getArguments().size(); ++iter1) {
            boolean castFlag;
            Mutable argExpr = (Mutable)funcCallExpr.getArguments().get(iter1);
            IAType inputRecordType = (IAType)op.computeOutputTypeEnvironment((ITypingContext)context).getType((ILogicalExpression)argExpr.getValue());
            if (!(((ExternalScalarFunctionInfo)funcCallExpr.getFunctionInfo()).getArgumenTypes().get(iter1) instanceof ARecordType)) continue;
            ARecordType requiredRecordType = (ARecordType)((ExternalScalarFunctionInfo)funcCallExpr.getFunctionInfo()).getArgumenTypes().get(iter1);
            boolean checkUnknown = false;
            while (NonTaggedFormatUtil.isOptional((IAType)inputRecordType)) {
                inputRecordType = ((AUnionType)inputRecordType).getActualType();
                checkUnknown = true;
            }
            boolean bl = castFlag = !IntroduceDynamicTypeCastRule.compatible(requiredRecordType, inputRecordType, ((ILogicalExpression)argExpr.getValue()).getSourceLocation());
            if (!castFlag && !checkUnknown) continue;
            ScalarFunctionCallExpression castFunc = new ScalarFunctionCallExpression(FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CAST_TYPE));
            castFunc.setSourceLocation(((ILogicalExpression)argExpr.getValue()).getSourceLocation());
            castFunc.getArguments().add(argExpr);
            TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)castFunc, (IAType)requiredRecordType, (IAType)inputRecordType);
            funcCallExpr.getArguments().set(iter1, new MutableObject((Object)castFunc));
            changed = true;
        }
        return changed;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        return op.acceptExpressionTransform(expr -> this.rewriteFunctionArgs((ILogicalOperator)op, (Mutable<ILogicalExpression>)expr, context));
    }
}

