/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import org.apache.asterix.optimizer.base.AnalysisUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.rewriter.rules.AbstractExtractExprRule;

public class ExtractOrderExpressionsRule
extends AbstractExtractExprRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.ORDER) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1)) {
            return false;
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1);
        OrderOperator oo = (OrderOperator)op1;
        if (!this.orderHasComplexExpr(oo)) {
            return false;
        }
        Mutable opRef2 = (Mutable)oo.getInputs().get(0);
        for (Pair orderPair : oo.getOrderExpressions()) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)orderPair.second).getValue();
            if (expr.getExpressionTag() == LogicalExpressionTag.VARIABLE || AnalysisUtil.isAccessToFieldRecord(expr)) continue;
            LogicalVariable v = this.extractExprIntoAssignOpRef(expr, opRef2, context);
            VariableReferenceExpression vRef = new VariableReferenceExpression(v);
            vRef.setSourceLocation(expr.getSourceLocation());
            ((Mutable)orderPair.second).setValue((Object)vRef);
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)oo);
        return true;
    }

    private boolean orderHasComplexExpr(OrderOperator oo) {
        for (Pair orderPair : oo.getOrderExpressions()) {
            if (((ILogicalExpression)((Mutable)orderPair.second).getValue()).getExpressionTag() == LogicalExpressionTag.VARIABLE) continue;
            return true;
        }
        return false;
    }
}

