/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.rewriter.rules.AbstractExtractExprRule;

public class ExtractDistinctByExpressionsRule
extends AbstractExtractExprRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.DISTINCT) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1)) {
            return false;
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1);
        DistinctOperator d = (DistinctOperator)op1;
        boolean changed = false;
        Mutable opRef2 = (Mutable)d.getInputs().get(0);
        ArrayList<Object> newExprList = new ArrayList<Object>();
        for (Mutable expr : d.getExpressions()) {
            LogicalExpressionTag tag = ((ILogicalExpression)expr.getValue()).getExpressionTag();
            if (tag == LogicalExpressionTag.VARIABLE || tag == LogicalExpressionTag.CONSTANT) {
                newExprList.add(expr);
                continue;
            }
            LogicalVariable v = this.extractExprIntoAssignOpRef((ILogicalExpression)expr.getValue(), opRef2, context);
            VariableReferenceExpression newExpr = new VariableReferenceExpression(v);
            newExpr.setSourceLocation(((ILogicalExpression)expr.getValue()).getSourceLocation());
            newExprList.add(new MutableObject((Object)newExpr));
            changed = true;
        }
        if (changed) {
            d.getExpressions().clear();
            d.getExpressions().addAll(newExprList);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)d);
        }
        return changed;
    }
}

