/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.HashSet;
import java.util.List;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IndexedNLJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class DisjunctivePredicateToJoinRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        if (metadataProvider.isBlockingOperatorDisabled()) {
            return false;
        }
        SelectOperator select = DisjunctivePredicateToJoinRule.asSelectOperator(opRef);
        if (select == null) {
            return false;
        }
        AbstractFunctionCallExpression condEx = DisjunctivePredicateToJoinRule.asFunctionCallExpression((Mutable<ILogicalExpression>)select.getCondition(), AlgebricksBuiltinFunctions.OR);
        if (condEx == null) {
            return false;
        }
        List args = condEx.getArguments();
        VariableReferenceExpression varEx = null;
        IAType valType = null;
        HashSet<AsterixConstantValue> values = new HashSet<AsterixConstantValue>();
        for (Mutable arg : args) {
            AbstractFunctionCallExpression fctCall = DisjunctivePredicateToJoinRule.asFunctionCallExpression((Mutable<ILogicalExpression>)arg, AlgebricksBuiltinFunctions.EQ);
            if (fctCall == null) {
                return false;
            }
            boolean haveConst = false;
            boolean haveVar = false;
            List fctArgs = fctCall.getArguments();
            block5: for (Mutable fctArg : fctArgs) {
                ILogicalExpression argExpr = (ILogicalExpression)fctArg.getValue();
                switch (argExpr.getExpressionTag()) {
                    case CONSTANT: {
                        haveConst = true;
                        AsterixConstantValue value = (AsterixConstantValue)((ConstantExpression)argExpr).getValue();
                        if (valType == null) {
                            valType = value.getObject().getType();
                        } else if (!DisjunctivePredicateToJoinRule.isCompatible(valType, value.getObject().getType())) {
                            return false;
                        }
                        values.add(value);
                        continue block5;
                    }
                    case VARIABLE: {
                        haveVar = true;
                        VariableReferenceExpression varArg = (VariableReferenceExpression)argExpr;
                        if (varEx == null) {
                            varEx = varArg;
                            continue block5;
                        }
                        if (varEx.getVariableReference().equals((Object)varArg.getVariableReference())) continue block5;
                        return false;
                    }
                }
                return false;
            }
            if (haveVar && haveConst) continue;
            return false;
        }
        SourceLocation sourceLoc = select.getSourceLocation();
        AOrderedList list = new AOrderedList(new AOrderedListType(valType, "orderedlist"));
        for (AsterixConstantValue value : values) {
            list.add(value.getObject());
        }
        EmptyTupleSourceOperator ets = new EmptyTupleSourceOperator();
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)ets);
        ConstantExpression cExp = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)list));
        MutableObject mutCExp = new MutableObject((Object)cExp);
        IFunctionInfo scanFctInfo = BuiltinFunctions.getAsterixFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION);
        UnnestingFunctionCallExpression scanExp = new UnnestingFunctionCallExpression(scanFctInfo, new Mutable[]{mutCExp});
        scanExp.setSourceLocation(sourceLoc);
        LogicalVariable scanVar = context.newVar();
        UnnestOperator unn = new UnnestOperator(scanVar, (Mutable)new MutableObject((Object)scanExp));
        unn.setSourceLocation(sourceLoc);
        unn.getInputs().add(new MutableObject((Object)ets));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unn);
        IFunctionInfo eqFctInfo = BuiltinFunctions.getAsterixFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.EQ);
        ScalarFunctionCallExpression eqExp = new ScalarFunctionCallExpression(eqFctInfo);
        eqExp.setSourceLocation(sourceLoc);
        VariableReferenceExpression scanVarRef = new VariableReferenceExpression(scanVar);
        scanVarRef.setSourceLocation(sourceLoc);
        eqExp.getArguments().add(new MutableObject((Object)scanVarRef));
        eqExp.getArguments().add(new MutableObject((Object)varEx.cloneExpression()));
        eqExp.getAnnotations().put(IndexedNLJoinExpressionAnnotation.INSTANCE, IndexedNLJoinExpressionAnnotation.INSTANCE);
        BroadcastExpressionAnnotation bcast = new BroadcastExpressionAnnotation();
        bcast.setObject((Object)BroadcastExpressionAnnotation.BroadcastSide.LEFT);
        eqExp.getAnnotations().put("broadcast", bcast);
        InnerJoinOperator jOp = new InnerJoinOperator((Mutable)new MutableObject((Object)eqExp));
        jOp.setSourceLocation(sourceLoc);
        jOp.getInputs().add(new MutableObject((Object)unn));
        jOp.getInputs().add(select.getInputs().get(0));
        opRef.setValue((Object)jOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)jOp);
        return true;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    private static boolean isCompatible(IAType t1, IAType t2) {
        return t1.equals(t2);
    }

    private static SelectOperator asSelectOperator(ILogicalOperator op) {
        return op.getOperatorTag() == LogicalOperatorTag.SELECT ? (SelectOperator)op : null;
    }

    private static SelectOperator asSelectOperator(Mutable<ILogicalOperator> op) {
        return DisjunctivePredicateToJoinRule.asSelectOperator((ILogicalOperator)op.getValue());
    }

    private static AbstractFunctionCallExpression asFunctionCallExpression(ILogicalExpression ex, FunctionIdentifier fi) {
        AbstractFunctionCallExpression fctCall;
        AbstractFunctionCallExpression abstractFunctionCallExpression = fctCall = ex.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL ? (AbstractFunctionCallExpression)ex : null;
        if (fctCall != null && (fi == null || fctCall.getFunctionIdentifier().equals((Object)fi))) {
            return fctCall;
        }
        return null;
    }

    private static AbstractFunctionCallExpression asFunctionCallExpression(Mutable<ILogicalExpression> ex, FunctionIdentifier fi) {
        return DisjunctivePredicateToJoinRule.asFunctionCallExpression((ILogicalExpression)ex.getValue(), fi);
    }
}

