/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.dataflow.data.common.ExpressionTypeComputer;
import org.apache.asterix.dataflow.data.nontagged.MissingWriterFactory;
import org.apache.asterix.formats.nontagged.ADMPrinterFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryBooleanInspector;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFamilyProvider;
import org.apache.asterix.formats.nontagged.BinaryIntegerInspector;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.jobgen.QueryLogicalExpressionJobGen;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.ILogicalExpressionJobGen;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.algebricks.data.IBinaryHashFunctionFactoryProvider;
import org.apache.hyracks.algebricks.data.IBinaryHashFunctionFamilyProvider;
import org.apache.hyracks.algebricks.data.IPrinterFactoryProvider;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.data.ITypeTraitProvider;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.comm.util.ByteBufferInputStream;

public class ConstantFoldingRule
implements IAlgebraicRewriteRule {
    private final ConstantFoldingVisitor cfv = new ConstantFoldingVisitor();
    private final JobGenContext jobGenCtx;
    private static final ImmutableSet<FunctionIdentifier> FUNC_ID_SET_THAT_SHOULD_NOT_BE_APPLIED = ImmutableSet.of((Object)BuiltinFunctions.RECORD_MERGE, (Object)BuiltinFunctions.ADD_FIELDS, (Object)BuiltinFunctions.REMOVE_FIELDS, (Object)BuiltinFunctions.GET_RECORD_FIELDS, (Object)BuiltinFunctions.GET_RECORD_FIELD_VALUE, (Object)BuiltinFunctions.FIELD_ACCESS_NESTED, (Object[])new FunctionIdentifier[]{BuiltinFunctions.GET_ITEM, BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR, BuiltinFunctions.FIELD_ACCESS_BY_INDEX, BuiltinFunctions.CAST_TYPE, BuiltinFunctions.META, BuiltinFunctions.META_KEY, BuiltinFunctions.RECORD_CONCAT, BuiltinFunctions.RECORD_CONCAT_STRICT, BuiltinFunctions.RECORD_PAIRS, BuiltinFunctions.PAIRS, BuiltinFunctions.TO_ATOMIC, BuiltinFunctions.TO_ARRAY});
    private static final Map<FunctionIdentifier, IAObject> FUNC_ID_TO_CONSTANT = ImmutableMap.of((Object)BuiltinFunctions.NUMERIC_E, (Object)new ADouble(Math.E), (Object)BuiltinFunctions.NUMERIC_PI, (Object)new ADouble(Math.PI));
    private static final IVariableTypeEnvironment _emptyTypeEnv = new IVariableTypeEnvironment(){

        public boolean substituteProducedVariable(LogicalVariable v1, LogicalVariable v2) {
            throw new IllegalStateException();
        }

        public void setVarType(LogicalVariable var, Object type) {
            throw new IllegalStateException();
        }

        public Object getVarType(LogicalVariable var, List<LogicalVariable> nonNullVariables, List<List<LogicalVariable>> correlatedNullableVariableLists) {
            throw new IllegalStateException();
        }

        public Object getVarType(LogicalVariable var) {
            throw new IllegalStateException();
        }

        public Object getType(ILogicalExpression expr) throws AlgebricksException {
            return ExpressionTypeComputer.INSTANCE.getType(expr, null, (IVariableTypeEnvironment)this);
        }
    };
    private static final IOperatorSchema[] _emptySchemas = new IOperatorSchema[0];

    public ConstantFoldingRule(ICcApplicationContext appCtx) {
        MetadataProvider metadataProvider = new MetadataProvider(appCtx, null);
        this.jobGenCtx = new JobGenContext(null, (IMetadataProvider)metadataProvider, (Object)appCtx, (ISerializerDeserializerProvider)SerializerDeserializerProvider.INSTANCE, (IBinaryHashFunctionFactoryProvider)BinaryHashFunctionFactoryProvider.INSTANCE, (IBinaryHashFunctionFamilyProvider)BinaryHashFunctionFamilyProvider.INSTANCE, (IBinaryComparatorFactoryProvider)BinaryComparatorFactoryProvider.INSTANCE, (ITypeTraitProvider)TypeTraitProvider.INSTANCE, BinaryBooleanInspector.FACTORY, BinaryIntegerInspector.FACTORY, (IPrinterFactoryProvider)ADMPrinterFactoryProvider.INSTANCE, (IMissingWriterFactory)MissingWriterFactory.INSTANCE, null, (IExpressionRuntimeProvider)new ExpressionRuntimeProvider((ILogicalExpressionJobGen)new QueryLogicalExpressionJobGen(metadataProvider.getFunctionManager())), (IExpressionTypeComputer)ExpressionTypeComputer.INSTANCE, null, null, null, null, 32768, null);
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op)) {
            return false;
        }
        return op.acceptExpressionTransform((ILogicalExpressionReferenceTransform)this.cfv);
    }

    private class ConstantFoldingVisitor
    implements ILogicalExpressionVisitor<Pair<Boolean, ILogicalExpression>, Void>,
    ILogicalExpressionReferenceTransform {
        private final IPointable p = VoidPointable.FACTORY.createPointable();
        private final ByteBufferInputStream bbis = new ByteBufferInputStream();
        private final DataInputStream dis = new DataInputStream((InputStream)this.bbis);

        private ConstantFoldingVisitor() {
        }

        public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
            AbstractLogicalExpression expr = (AbstractLogicalExpression)exprRef.getValue();
            Pair p = (Pair)expr.accept((ILogicalExpressionVisitor)this, null);
            if (((Boolean)p.first).booleanValue()) {
                exprRef.setValue(p.second);
            }
            return (Boolean)p.first;
        }

        public Pair<Boolean, ILogicalExpression> visitConstantExpression(ConstantExpression expr, Void arg) {
            return new Pair((Object)false, (Object)expr);
        }

        public Pair<Boolean, ILogicalExpression> visitVariableReferenceExpression(VariableReferenceExpression expr, Void arg) {
            return new Pair((Object)false, (Object)expr);
        }

        public Pair<Boolean, ILogicalExpression> visitScalarFunctionCallExpression(ScalarFunctionCallExpression expr, Void arg) throws AlgebricksException {
            boolean changed = this.changeRec((AbstractFunctionCallExpression)expr, arg);
            if (!this.checkArgs((AbstractFunctionCallExpression)expr) || !expr.isFunctional()) {
                return new Pair((Object)changed, (Object)expr);
            }
            if (FUNC_ID_SET_THAT_SHOULD_NOT_BE_APPLIED.contains((Object)expr.getFunctionIdentifier())) {
                return new Pair((Object)false, null);
            }
            try {
                String str;
                ARecordType rt;
                int k;
                AbstractCollectionType listType;
                if ((expr.getFunctionIdentifier().equals((Object)BuiltinFunctions.UNORDERED_LIST_CONSTRUCTOR) || expr.getFunctionIdentifier().equals((Object)BuiltinFunctions.ORDERED_LIST_CONSTRUCTOR)) && (listType = (AbstractCollectionType)TypeCastUtils.getRequiredType((AbstractFunctionCallExpression)expr)) != null && (listType.getItemType().getTypeTag() == ATypeTag.ANY || listType.getItemType() instanceof AbstractCollectionType)) {
                    return new Pair((Object)false, null);
                }
                if (expr.getFunctionIdentifier().equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME) && (k = (rt = (ARecordType)_emptyTypeEnv.getType((ILogicalExpression)((Mutable)expr.getArguments().get(0)).getValue())).getFieldIndex(str = ConstantExpressionUtil.getStringConstant((ILogicalExpression)((ILogicalExpression)((Mutable)expr.getArguments().get(1)).getValue())))) >= 0) {
                    return new Pair((Object)changed, (Object)expr);
                }
                IAObject c = (IAObject)FUNC_ID_TO_CONSTANT.get(expr.getFunctionIdentifier());
                if (c != null) {
                    return new Pair((Object)true, (Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(c)));
                }
                IScalarEvaluatorFactory fact = ConstantFoldingRule.this.jobGenCtx.getExpressionRuntimeProvider().createEvaluatorFactory((ILogicalExpression)expr, _emptyTypeEnv, _emptySchemas, ConstantFoldingRule.this.jobGenCtx);
                IScalarEvaluator eval = fact.createScalarEvaluator(null);
                eval.evaluate(null, this.p);
                Object t = _emptyTypeEnv.getType((ILogicalExpression)expr);
                ISerializerDeserializer serde = ConstantFoldingRule.this.jobGenCtx.getSerializerDeserializerProvider().getSerializerDeserializer(t);
                this.bbis.setByteBuffer(ByteBuffer.wrap(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength()), 0);
                IAObject o = (IAObject)serde.deserialize((DataInput)this.dis);
                return new Pair((Object)true, (Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(o)));
            }
            catch (AlgebricksException | HyracksDataException e) {
                if (AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled()) {
                    AlgebricksConfig.ALGEBRICKS_LOGGER.trace("Exception caught at constant folding: " + e, e);
                }
                return new Pair((Object)false, null);
            }
        }

        public Pair<Boolean, ILogicalExpression> visitAggregateFunctionCallExpression(AggregateFunctionCallExpression expr, Void arg) throws AlgebricksException {
            boolean changed = this.changeRec((AbstractFunctionCallExpression)expr, arg);
            return new Pair((Object)changed, (Object)expr);
        }

        public Pair<Boolean, ILogicalExpression> visitStatefulFunctionCallExpression(StatefulFunctionCallExpression expr, Void arg) throws AlgebricksException {
            boolean changed = this.changeRec((AbstractFunctionCallExpression)expr, arg);
            return new Pair((Object)changed, (Object)expr);
        }

        public Pair<Boolean, ILogicalExpression> visitUnnestingFunctionCallExpression(UnnestingFunctionCallExpression expr, Void arg) throws AlgebricksException {
            boolean changed = this.changeRec((AbstractFunctionCallExpression)expr, arg);
            return new Pair((Object)changed, (Object)expr);
        }

        private boolean changeRec(AbstractFunctionCallExpression expr, Void arg) throws AlgebricksException {
            boolean changed = false;
            for (Mutable r : expr.getArguments()) {
                Pair p2 = (Pair)((ILogicalExpression)r.getValue()).accept((ILogicalExpressionVisitor)this, (Object)arg);
                if (!((Boolean)p2.first).booleanValue()) continue;
                r.setValue(p2.second);
                changed = true;
            }
            return changed;
        }

        private boolean checkArgs(AbstractFunctionCallExpression expr) {
            for (Mutable r : expr.getArguments()) {
                if (((ILogicalExpression)r.getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT) continue;
                return false;
            }
            return true;
        }
    }
}

