/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.base;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractDataSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;

public class AnalysisUtil {
    private static List<FunctionIdentifier> fieldAccessFunctions = new ArrayList<FunctionIdentifier>();

    public static final ILogicalOperator firstChildOfType(AbstractLogicalOperator op, LogicalOperatorTag opType) {
        List ins = op.getInputs();
        if (ins == null || ins.isEmpty()) {
            return null;
        }
        Mutable opRef2 = (Mutable)ins.get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (op2.getOperatorTag() == opType) {
            return op2;
        }
        return null;
    }

    public static int numberOfVarsInExpr(ILogicalExpression e) {
        switch (e.getExpressionTag()) {
            case CONSTANT: {
                return 0;
            }
            case FUNCTION_CALL: {
                AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)e;
                int s = 0;
                for (Mutable arg : f.getArguments()) {
                    s += AnalysisUtil.numberOfVarsInExpr((ILogicalExpression)arg.getValue());
                }
                return s;
            }
            case VARIABLE: {
                return 1;
            }
        }
        assert (false);
        throw new IllegalArgumentException();
    }

    public static boolean isRunnableFieldAccessFunction(FunctionIdentifier fid) {
        return fieldAccessFunctions.contains(fid);
    }

    public static boolean isRunnableAccessToFieldRecord(ILogicalExpression expr) {
        AbstractFunctionCallExpression fc;
        FunctionIdentifier fid;
        return expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && AnalysisUtil.isRunnableFieldAccessFunction(fid = (fc = (AbstractFunctionCallExpression)expr).getFunctionIdentifier());
    }

    public static boolean isAccessByNameToFieldRecord(ILogicalExpression expr) {
        AbstractFunctionCallExpression fc;
        FunctionIdentifier fid;
        return expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && (fid = (fc = (AbstractFunctionCallExpression)expr).getFunctionIdentifier()).equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME);
    }

    public static boolean isAccessToFieldRecord(ILogicalExpression expr) {
        AbstractFunctionCallExpression fc;
        FunctionIdentifier fid;
        return expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && ((fid = (fc = (AbstractFunctionCallExpression)expr).getFunctionIdentifier()).equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_INDEX) || fid.equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME) || fid.equals((Object)BuiltinFunctions.FIELD_ACCESS_NESTED));
    }

    public static Pair<String, String> getDatasetInfo(AbstractDataSourceOperator op) throws AlgebricksException {
        DataSourceId srcId = (DataSourceId)op.getDataSource().getId();
        return new Pair((Object)srcId.getDataverseName(), (Object)srcId.getDatasourceName());
    }

    public static Pair<String, String> getExternalDatasetInfo(UnnestMapOperator op) throws AlgebricksException {
        AbstractFunctionCallExpression unnestExpr = (AbstractFunctionCallExpression)op.getExpressionRef().getValue();
        String dataverseName = AccessMethodUtils.getStringConstant((Mutable<ILogicalExpression>)((Mutable)unnestExpr.getArguments().get(0)));
        String datasetName = AccessMethodUtils.getStringConstant((Mutable<ILogicalExpression>)((Mutable)unnestExpr.getArguments().get(1)));
        return new Pair((Object)dataverseName, (Object)datasetName);
    }

    static {
        fieldAccessFunctions.add(BuiltinFunctions.GET_DATA);
        fieldAccessFunctions.add(BuiltinFunctions.GET_HANDLE);
        fieldAccessFunctions.add(BuiltinFunctions.TYPE_OF);
    }
}

