/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotifyTaskCompleteWork
extends AbstractWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService ncs;
    private final Task task;

    public NotifyTaskCompleteWork(NodeControllerService ncs, Task task) {
        this.ncs = ncs;
        this.task = task;
    }

    public void run() {
        TaskProfile taskProfile = new TaskProfile(this.task.getTaskAttemptId(), this.task.getPartitionSendProfile(), this.task.getStatsCollector());
        try {
            this.ncs.getClusterController(this.task.getJobletContext().getJobId().getCcId()).notifyTaskComplete(this.task.getJobletContext().getJobId(), this.task.getTaskAttemptId(), this.ncs.getId(), taskProfile);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Failed notifying task complete for " + this.task.getTaskAttemptId(), (Throwable)e);
        }
        this.task.getJoblet().removeTask(this.task);
    }

    public String toString() {
        return this.getName() + ": [" + this.ncs.getId() + "[" + this.task.getJoblet().getJobId() + ":" + this.task.getTaskAttemptId() + "]";
    }
}

