/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.utils;

import java.io.IOException;
import org.apache.asterix.runtime.evaluators.functions.StringEvaluatorUtils;
import org.apache.commons.lang3.CharSet;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;

public class StringTrimmer {
    private final ByteArrayAccessibleOutputStream lastPatternStorage = new ByteArrayAccessibleOutputStream();
    private final UTF8StringPointable lastPatternPtr = new UTF8StringPointable();
    private CharSet charSet;
    private final UTF8StringBuilder resultBuilder;
    private final GrowableArray resultArray;

    public StringTrimmer(UTF8StringBuilder resultBuilder, GrowableArray resultArray) {
        this(resultBuilder, resultArray, null);
    }

    public StringTrimmer(UTF8StringBuilder resultBuilder, GrowableArray resultArray, String pattern) {
        this.resultBuilder = resultBuilder;
        this.resultArray = resultArray;
        if (pattern != null) {
            this.charSet = CharSet.getInstance((String[])new String[]{pattern});
        }
    }

    public void build(UTF8StringPointable patternPtr) {
        boolean newPattern;
        boolean bl = newPattern = this.charSet == null || this.lastPatternPtr.compareTo((IPointable)patternPtr) != 0;
        if (newPattern) {
            StringEvaluatorUtils.copyResetUTF8Pointable(patternPtr, this.lastPatternStorage, this.lastPatternPtr);
            this.charSet = CharSet.getInstance((String[])new String[]{patternPtr.toString()});
        }
    }

    public void trim(UTF8StringPointable srcPtr, IPointable resultStrPtr, boolean left, boolean right) throws IOException {
        UTF8StringPointable.trim((UTF8StringPointable)srcPtr, (UTF8StringBuilder)this.resultBuilder, (GrowableArray)this.resultArray, (boolean)left, (boolean)right, (CharSet)this.charSet);
        resultStrPtr.set(this.resultArray.getByteArray(), 0, this.resultArray.getLength());
    }
}

