/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.temporal.DateTimeFormatUtils;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ParseDateTimeDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ParseDateTimeDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable argPtr0 = new VoidPointable();
                    private final IPointable argPtr1 = new VoidPointable();
                    private final IScalarEvaluator eval0;
                    private final IScalarEvaluator eval1;
                    private final ISerializerDeserializer<ADateTime> datetimeSerde;
                    private final AMutableInt64 aInt64;
                    private final AMutableDateTime aDateTime;
                    private final UTF8StringPointable utf8Ptr;
                    private final DateTimeFormatUtils util;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.datetimeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
                        this.aInt64 = new AMutableInt64(0L);
                        this.aDateTime = new AMutableDateTime(0L);
                        this.utf8Ptr = new UTF8StringPointable();
                        this.util = DateTimeFormatUtils.getInstance();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        int formatLength;
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, this.argPtr0);
                        this.eval1.evaluate(tuple, this.argPtr1);
                        byte[] bytes0 = this.argPtr0.getByteArray();
                        int offset0 = this.argPtr0.getStartOffset();
                        int len0 = this.argPtr0.getLength();
                        byte[] bytes1 = this.argPtr1.getByteArray();
                        int offset1 = this.argPtr1.getStartOffset();
                        int len1 = this.argPtr1.getLength();
                        if (bytes0[offset0] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                            throw new TypeMismatchException(ParseDateTimeDescriptor.this.sourceLoc, ParseDateTimeDescriptor.this.getIdentifier(), (Integer)0, bytes0[offset0], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                        }
                        if (bytes1[offset1] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                            throw new TypeMismatchException(ParseDateTimeDescriptor.this.sourceLoc, ParseDateTimeDescriptor.this.getIdentifier(), (Integer)1, bytes1[offset1], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                        }
                        this.utf8Ptr.set(bytes0, offset0 + 1, len0 - 1);
                        int start0 = this.utf8Ptr.getCharStartOffset();
                        int length0 = this.utf8Ptr.getUTF8Length();
                        this.utf8Ptr.set(bytes1, offset1 + 1, len1 - 1);
                        int start1 = this.utf8Ptr.getCharStartOffset();
                        int length1 = this.utf8Ptr.getUTF8Length();
                        boolean processSuccessfully = false;
                        for (int formatStart = start1; !processSuccessfully && formatStart < start1 + length1; formatStart += formatLength + 1) {
                            formatLength = 0;
                            while (formatStart + formatLength < start1 + length1 && bytes1[formatStart + formatLength] != 124) {
                                ++formatLength;
                            }
                            processSuccessfully = this.util.parseDateTime(this.aInt64, bytes0, start0, length0, bytes1, formatStart, formatLength, DateTimeFormatUtils.DateTimeParseMode.DATETIME, false);
                        }
                        if (!processSuccessfully) {
                            throw new InvalidDataFormatException(ParseDateTimeDescriptor.this.sourceLoc, ParseDateTimeDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                        }
                        this.aDateTime.setValue(this.aInt64.getLongValue());
                        this.datetimeSerde.serialize((Object)this.aDateTime, this.out);
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.PARSE_DATETIME;
    }
}

