/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADayTimeDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AIntervalSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AYearMonthDurationSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInterval;
import org.apache.asterix.om.base.AMutableInterval;
import org.apache.asterix.om.base.temporal.DurationArithmeticOperations;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.OverflowException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnderflowException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class OverlapBinsDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new OverlapBinsDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable argPtr0 = new VoidPointable();
                    private final IPointable argPtr1 = new VoidPointable();
                    private final IPointable argPtr2 = new VoidPointable();
                    private final IScalarEvaluator eval0;
                    private final IScalarEvaluator eval1;
                    private final IScalarEvaluator eval2;
                    private OrderedListBuilder listBuilder;
                    private ArrayBackedValueStorage listStorage;
                    protected final AOrderedListType intListType;
                    private final AMutableInterval aInterval;
                    private final ISerializerDeserializer<AInterval> intervalSerde;
                    private final GregorianCalendarSystem gregCalSys;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.eval2 = args[2].createScalarEvaluator(ctx);
                        this.listBuilder = new OrderedListBuilder();
                        this.listStorage = new ArrayBackedValueStorage();
                        this.intListType = new AOrderedListType((IAType)BuiltinType.AINTERVAL, null);
                        this.aInterval = new AMutableInterval(0L, 0L, -1);
                        this.intervalSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINTERVAL);
                        this.gregCalSys = GregorianCalendarSystem.getInstance();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        long firstBinIndex;
                        long anchorTime;
                        byte intervalTypeTag;
                        long intervalEnd;
                        long intervalStart;
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, this.argPtr0);
                        this.eval1.evaluate(tuple, this.argPtr1);
                        this.eval2.evaluate(tuple, this.argPtr2);
                        byte[] bytes0 = this.argPtr0.getByteArray();
                        int offset0 = this.argPtr0.getStartOffset();
                        ATypeTag type0 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes0[offset0]);
                        if (type0 == ATypeTag.INTERVAL) {
                            intervalStart = AIntervalSerializerDeserializer.getIntervalStart((byte[])bytes0, (int)(offset0 + 1));
                            intervalEnd = AIntervalSerializerDeserializer.getIntervalEnd((byte[])bytes0, (int)(offset0 + 1));
                            intervalTypeTag = AIntervalSerializerDeserializer.getIntervalTimeType((byte[])bytes0, (int)(offset0 + 1));
                            if (intervalTypeTag == ATypeTag.SERIALIZED_DATE_TYPE_TAG) {
                                intervalStart *= 86400000L;
                            }
                        } else {
                            throw new TypeMismatchException(OverlapBinsDescriptor.this.sourceLoc, OverlapBinsDescriptor.this.getIdentifier(), (Integer)0, bytes0[offset0], ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                        }
                        byte[] bytes1 = this.argPtr1.getByteArray();
                        int offset1 = this.argPtr1.getStartOffset();
                        ATypeTag type1 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes1[offset1]);
                        if (intervalTypeTag != bytes1[offset1]) {
                            throw new IncompatibleTypeException(OverlapBinsDescriptor.this.sourceLoc, OverlapBinsDescriptor.this.getIdentifier(), intervalTypeTag, bytes1[offset1]);
                        }
                        switch (type1) {
                            case DATE: {
                                anchorTime = (long)ADateSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1)) * 86400000L;
                                break;
                            }
                            case TIME: {
                                anchorTime = ATimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                break;
                            }
                            case DATETIME: {
                                anchorTime = ADateTimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                break;
                            }
                            default: {
                                throw new TypeMismatchException(OverlapBinsDescriptor.this.sourceLoc, OverlapBinsDescriptor.this.getIdentifier(), (Integer)1, bytes1[offset1], ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                            }
                        }
                        byte[] bytes2 = this.argPtr2.getByteArray();
                        int offset2 = this.argPtr2.getStartOffset();
                        ATypeTag type2 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes2[offset2]);
                        int yearMonth = 0;
                        long dayTime = 0L;
                        switch (type2) {
                            case YEARMONTHDURATION: {
                                yearMonth = AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes2, (int)(offset2 + 1));
                                int yearStart = this.gregCalSys.getYear(anchorTime);
                                int monthStart = this.gregCalSys.getMonthOfYear(anchorTime, yearStart);
                                int yearToBin = this.gregCalSys.getYear(intervalStart);
                                int monthToBin = this.gregCalSys.getMonthOfYear(intervalStart, yearToBin);
                                int totalMonths = (yearToBin - yearStart) * 12 + (monthToBin - monthStart);
                                firstBinIndex = totalMonths / yearMonth + (totalMonths < 0 && totalMonths % yearMonth != 0 ? -1 : 0);
                                if (firstBinIndex > Integer.MAX_VALUE) {
                                    throw new OverflowException(OverlapBinsDescriptor.this.sourceLoc, OverlapBinsDescriptor.this.getIdentifier());
                                }
                                if (firstBinIndex >= Integer.MIN_VALUE) break;
                                throw new UnderflowException(OverlapBinsDescriptor.this.sourceLoc, OverlapBinsDescriptor.this.getIdentifier());
                            }
                            case DAYTIMEDURATION: {
                                dayTime = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes2, (int)(offset2 + 1));
                                long totalChronon = intervalStart - anchorTime;
                                firstBinIndex = totalChronon / dayTime + (long)(totalChronon < 0L && totalChronon % dayTime != 0L ? -1 : 0);
                                break;
                            }
                            default: {
                                throw new TypeMismatchException(OverlapBinsDescriptor.this.sourceLoc, OverlapBinsDescriptor.this.getIdentifier(), (Integer)2, bytes2[offset2], ATypeTag.SERIALIZED_YEAR_MONTH_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_DAY_TIME_DURATION_TYPE_TAG);
                            }
                        }
                        this.listBuilder.reset((AbstractCollectionType)this.intListType);
                        try {
                            int binOffset;
                            if (intervalTypeTag == ATypeTag.SERIALIZED_DATE_TYPE_TAG) {
                                long binEndChronon;
                                binOffset = 0;
                                do {
                                    long binStartChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * (int)(firstBinIndex + (long)binOffset)), (long)(dayTime * (firstBinIndex + (long)binOffset)), (boolean)false);
                                    binEndChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * ((int)(firstBinIndex + (long)binOffset) + 1)), (long)(dayTime * (firstBinIndex + (long)binOffset + 1L)), (boolean)false);
                                    binStartChronon = binStartChronon / 86400000L + (long)(binStartChronon < 0L && binStartChronon % 86400000L != 0L ? -1 : 0);
                                    binEndChronon = binEndChronon / 86400000L + (long)(binEndChronon < 0L && binEndChronon % 86400000L != 0L ? -1 : 0);
                                    this.aInterval.setValue(binStartChronon, binEndChronon, intervalTypeTag);
                                    this.listStorage.reset();
                                    this.intervalSerde.serialize((Object)this.aInterval, this.listStorage.getDataOutput());
                                    this.listBuilder.addItem((IValueReference)this.listStorage);
                                    ++binOffset;
                                } while (binEndChronon < intervalEnd);
                            } else if (intervalTypeTag == ATypeTag.SERIALIZED_TIME_TYPE_TAG) {
                                if (yearMonth != 0) {
                                    throw new InvalidDataFormatException(OverlapBinsDescriptor.this.sourceLoc, OverlapBinsDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                                }
                                binOffset = 0;
                                long binStartChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * (int)(firstBinIndex + (long)binOffset)), (long)(dayTime * (firstBinIndex + (long)binOffset)), (boolean)true);
                                long binEndChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * ((int)(firstBinIndex + (long)binOffset) + 1)), (long)(dayTime * (firstBinIndex + (long)binOffset + 1L)), (boolean)true);
                                if (binStartChronon < 0L || binStartChronon >= 86400000L) {
                                    throw new InvalidDataFormatException(OverlapBinsDescriptor.this.sourceLoc, OverlapBinsDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                                }
                                while (!(binStartChronon < intervalStart && binEndChronon <= intervalStart || binStartChronon >= intervalEnd && binEndChronon > intervalEnd)) {
                                    this.aInterval.setValue(binStartChronon, binEndChronon, intervalTypeTag);
                                    this.listStorage.reset();
                                    this.intervalSerde.serialize((Object)this.aInterval, this.listStorage.getDataOutput());
                                    this.listBuilder.addItem((IValueReference)this.listStorage);
                                    binStartChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * (int)(firstBinIndex + (long)(++binOffset))), (long)(dayTime * (firstBinIndex + (long)binOffset)), (boolean)true);
                                    binEndChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * ((int)(firstBinIndex + (long)binOffset) + 1)), (long)(dayTime * (firstBinIndex + (long)binOffset + 1L)), (boolean)true);
                                    if (binStartChronon != 86400000L) {
                                        if (binEndChronon >= binStartChronon) continue;
                                        throw new InvalidDataFormatException(OverlapBinsDescriptor.this.sourceLoc, OverlapBinsDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                                    }
                                    break;
                                }
                            } else if (intervalTypeTag == ATypeTag.SERIALIZED_DATETIME_TYPE_TAG) {
                                long binEndChronon;
                                binOffset = 0;
                                do {
                                    long binStartChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * (int)(firstBinIndex + (long)binOffset)), (long)(dayTime * (firstBinIndex + (long)binOffset)), (boolean)false);
                                    binEndChronon = DurationArithmeticOperations.addDuration((long)anchorTime, (int)(yearMonth * ((int)(firstBinIndex + (long)binOffset) + 1)), (long)(dayTime * (firstBinIndex + (long)binOffset + 1L)), (boolean)false);
                                    this.aInterval.setValue(binStartChronon, binEndChronon, intervalTypeTag);
                                    this.listStorage.reset();
                                    this.intervalSerde.serialize((Object)this.aInterval, this.listStorage.getDataOutput());
                                    this.listBuilder.addItem((IValueReference)this.listStorage);
                                    ++binOffset;
                                } while (binEndChronon < intervalEnd);
                            } else {
                                throw new TypeMismatchException(OverlapBinsDescriptor.this.sourceLoc, OverlapBinsDescriptor.this.getIdentifier(), (Integer)0, bytes0[offset0], ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                            }
                            this.listBuilder.write(this.out, true);
                        }
                        catch (IOException e1) {
                            throw HyracksDataException.create((Throwable)e1);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.OVERLAP_BINS;
    }
}

