/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.Serializable;
import org.apache.asterix.om.pointables.nonvisitor.AIntervalPointable;
import org.apache.asterix.runtime.evaluators.comparisons.ComparisonHelper;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;

public class IntervalLogic
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ComparisonHelper ch;
    private final transient IPointable s1 = VoidPointable.FACTORY.createPointable();
    private final transient IPointable e1 = VoidPointable.FACTORY.createPointable();
    private final transient IPointable s2 = VoidPointable.FACTORY.createPointable();
    private final transient IPointable e2 = VoidPointable.FACTORY.createPointable();

    public IntervalLogic(SourceLocation sourceLoc) {
        this.ch = new ComparisonHelper(sourceLoc);
    }

    public boolean validateInterval(AIntervalPointable ip1) throws HyracksDataException {
        ip1.getStart(this.s1);
        ip1.getEnd(this.e1);
        return this.ch.compare(ip1.getTypeTag(), ip1.getTypeTag(), this.s1, this.e1) <= 0;
    }

    public boolean before(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        ip1.getEnd(this.e1);
        ip2.getStart(this.s2);
        return this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.e1, this.s2) < 0;
    }

    public boolean after(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        return this.before(ip2, ip1);
    }

    public boolean meets(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        ip1.getEnd(this.e1);
        ip2.getStart(this.s2);
        return this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.e1, this.s2) == 0;
    }

    public boolean metBy(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        return this.meets(ip2, ip1);
    }

    public boolean overlaps(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        ip1.getStart(this.s1);
        ip1.getEnd(this.e1);
        ip2.getStart(this.s2);
        ip2.getEnd(this.e2);
        return this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.s1, this.s2) < 0 && this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.e1, this.s2) > 0 && this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.e1, this.e2) < 0;
    }

    public boolean overlappedBy(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        return this.overlaps(ip2, ip1);
    }

    public boolean overlapping(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        ip1.getStart(this.s1);
        ip1.getEnd(this.e1);
        ip2.getStart(this.s2);
        ip2.getEnd(this.e2);
        return this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.s1, this.e2) < 0 && this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.e1, this.s2) > 0;
    }

    public boolean starts(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        ip1.getStart(this.s1);
        ip1.getEnd(this.e1);
        ip2.getStart(this.s2);
        ip2.getEnd(this.e2);
        return this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.s1, this.s2) == 0 && this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.e1, this.e2) <= 0;
    }

    public boolean startedBy(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        return this.starts(ip2, ip1);
    }

    public boolean covers(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        ip1.getStart(this.s1);
        ip1.getEnd(this.e1);
        ip2.getStart(this.s2);
        ip2.getEnd(this.e2);
        return this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.s1, this.s2) <= 0 && this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.e1, this.e2) >= 0;
    }

    public boolean coveredBy(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        return this.covers(ip2, ip1);
    }

    public boolean ends(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        ip1.getStart(this.s1);
        ip1.getEnd(this.e1);
        ip2.getStart(this.s2);
        ip2.getEnd(this.e2);
        return this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.s1, this.s2) >= 0 && this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.e1, this.e2) == 0;
    }

    public boolean endedBy(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        return this.ends(ip2, ip1);
    }

    public boolean same(AIntervalPointable ip1, AIntervalPointable ip2) throws HyracksDataException {
        ip1.getStart(this.s1);
        ip1.getEnd(this.e1);
        ip2.getStart(this.s2);
        ip2.getEnd(this.e2);
        return this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.s1, this.s2) == 0 && this.ch.compare(ip1.getTypeTag(), ip2.getTypeTag(), this.e1, this.e2) == 0;
    }
}

