/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.cast.ACastVisitor;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class RecordUnwrapEvaluator
implements IScalarEvaluator {
    private final IPointable inputRecordPointable = new VoidPointable();
    private final IScalarEvaluator eval0;
    private ARecordVisitablePointable inputRecordVisitable;
    private ARecordVisitablePointable openRecordVisitablePointable;
    private boolean requiresCast = false;
    private ACastVisitor castVisitor;
    private Triple<IVisitablePointable, IAType, Boolean> castVisitorArg;
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput resultOutput = this.resultStorage.getDataOutput();

    RecordUnwrapEvaluator(IScalarEvaluator eval0, ARecordType recordType) {
        this.eval0 = eval0;
        this.openRecordVisitablePointable = new ARecordVisitablePointable(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        if (recordType != null) {
            this.inputRecordVisitable = new ARecordVisitablePointable(recordType);
            if (this.hasDerivedType(recordType.getFieldTypes())) {
                this.requiresCast = true;
                this.castVisitor = new ACastVisitor();
                this.castVisitorArg = new Triple((Object)this.openRecordVisitablePointable, (Object)this.openRecordVisitablePointable.getInputRecordType(), (Object)Boolean.FALSE);
            }
        }
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.eval0.evaluate(tuple, this.inputRecordPointable);
        byte[] data = this.inputRecordPointable.getByteArray();
        int offset = this.inputRecordPointable.getStartOffset();
        byte typeTag = data[offset];
        if (typeTag != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
            PointableHelper.setNull(result);
            return;
        }
        ARecordVisitablePointable inputRecordVisitablePointable = this.getInputRecordVisitablePointable();
        List recValues = inputRecordVisitablePointable.getFieldValues();
        if (recValues.size() != 1) {
            PointableHelper.setNull(result);
            return;
        }
        this.writeValue((IVisitablePointable)recValues.get(0));
        result.set((IValueReference)this.resultStorage);
    }

    private boolean hasDerivedType(IAType[] types) {
        for (IAType type : types) {
            if (!type.getTypeTag().isDerivedType()) continue;
            return true;
        }
        return false;
    }

    private ARecordVisitablePointable getInputRecordVisitablePointable() throws HyracksDataException {
        this.inputRecordVisitable.set((IValueReference)this.inputRecordPointable);
        if (this.requiresCast) {
            return this.castToOpenRecord();
        }
        return this.inputRecordVisitable;
    }

    private ARecordVisitablePointable castToOpenRecord() throws HyracksDataException {
        this.inputRecordVisitable.accept((IVisitablePointableVisitor)this.castVisitor, this.castVisitorArg);
        return this.openRecordVisitablePointable;
    }

    private void writeValue(IVisitablePointable value) throws HyracksDataException {
        try {
            this.resultOutput.write(value.getByteArray(), value.getStartOffset(), value.getLength());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

