/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.util.ArrayDeque;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.records.AbstractRecordPairsEvaluator$_EvaluatorGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

class PairsEvaluator$_EvaluatorGen
extends AbstractRecordPairsEvaluator$_EvaluatorGen {
    private final OrderedListBuilder outerListBuilder = new OrderedListBuilder();
    private final ArrayBackedValueStorage innerListStorage = new ArrayBackedValueStorage();
    private final DataOutput innerListOutput = this.innerListStorage.getDataOutput();
    private final OrderedListBuilder innerListBuilder = new OrderedListBuilder();
    private final PointableAllocator pAlloc = new PointableAllocator();
    private final ArrayDeque<IPointable> pNameQueue = new ArrayDeque();
    private final ArrayDeque<IPointable> pValueQueue = new ArrayDeque();
    private final VoidPointable nullPointable = new VoidPointable();
    private final TypeChecker typeChecker;

    PairsEvaluator$_EvaluatorGen(IScalarEvaluator eval0, IAType inputType) {
        super(eval0, inputType);
        PointableHelper.setNull((IPointable)this.nullPointable);
        this.typeChecker = new TypeChecker();
    }

    @Override
    protected void buildOutput() throws HyracksDataException {
        IPointable valuePointable;
        this.pAlloc.reset();
        this.pNameQueue.clear();
        this.pValueQueue.clear();
        this.outerListBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
        this.addMembersToQueue((IPointable)this.nullPointable, this.inputPointable);
        while ((valuePointable = this.pValueQueue.poll()) != null) {
            IPointable namePointable = this.pNameQueue.remove();
            this.addMembersToQueue(namePointable, valuePointable);
            if (PointableHelper.getTypeTag((IValueReference)namePointable) == ATypeTag.NULL) continue;
            this.innerListStorage.reset();
            this.innerListBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
            this.innerListBuilder.addItem((IValueReference)namePointable);
            this.innerListBuilder.addItem((IValueReference)valuePointable);
            this.innerListBuilder.write(this.innerListOutput, true);
            this.outerListBuilder.addItem((IValueReference)this.innerListStorage);
        }
        this.outerListBuilder.write(this.resultOutput, true);
    }

    private void addMembersToQueue(IPointable namePointable, IPointable valuePointable) {
        ATypeTag valueTypeTag = PointableHelper.getTypeTag((IValueReference)valuePointable);
        switch (valueTypeTag) {
            case OBJECT: {
                this.addRecordFieldsToQueue(valuePointable);
                break;
            }
            case ARRAY: 
            case MULTISET: {
                this.addListItemsToQueue(valuePointable, DefaultOpenFieldType.getDefaultOpenFieldType((ATypeTag)valueTypeTag), namePointable);
            }
        }
    }

    private void addRecordFieldsToQueue(IPointable recordPointable) {
        ARecordVisitablePointable visitablePointable = this.pAlloc.allocateRecordValue((IAType)DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        visitablePointable.set((IValueReference)recordPointable);
        List fieldNames = visitablePointable.getFieldNames();
        List fieldValues = visitablePointable.getFieldValues();
        for (int i = fieldNames.size() - 1; i >= 0; --i) {
            this.pNameQueue.push((IPointable)fieldNames.get(i));
            this.pValueQueue.push((IPointable)fieldValues.get(i));
        }
    }

    private void addListItemsToQueue(IPointable listPointable, IAType listType, IPointable fieldNamePointable) {
        AListVisitablePointable visitablePointable = this.pAlloc.allocateListValue(listType);
        visitablePointable.set((IValueReference)listPointable);
        List items = visitablePointable.getItems();
        for (int i = items.size() - 1; i >= 0; --i) {
            this.pNameQueue.push(fieldNamePointable);
            this.pValueQueue.push((IPointable)items.get(i));
        }
    }

    @Override
    protected boolean validateInputType(ATypeTag inputTypeTag) {
        return inputTypeTag == ATypeTag.OBJECT || inputTypeTag == ATypeTag.ARRAY || inputTypeTag == ATypeTag.MULTISET;
    }
}

