/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.runtime.RuntimeRecordTypeInfo;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.runtime.evaluators.functions.records.GetRecordFieldValueEvalFactory$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class GetRecordFieldValueEvalFactory$_EvaluatorGen
implements IScalarEvaluator {
    private final IBinaryHashFunction fieldNameHashFunction = BinaryHashFunctionFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryHashFunction();
    private final IBinaryComparator fieldNameComparator = BinaryComparatorFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryComparator();
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IPointable inputArg0 = new VoidPointable();
    private final IPointable inputArg1 = new VoidPointable();
    private final IScalarEvaluator recordEval = GetRecordFieldValueEvalFactory$_EvaluatorFactoryGen.access$000(this.this$0).createScalarEvaluator(this.val$ctx);
    private final IScalarEvaluator fieldNameEval = GetRecordFieldValueEvalFactory$_EvaluatorFactoryGen.access$100(this.this$0).createScalarEvaluator(this.val$ctx);
    private final RuntimeRecordTypeInfo recTypeInfo = new RuntimeRecordTypeInfo();
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ GetRecordFieldValueEvalFactory$_EvaluatorFactoryGen this$0;
    private final TypeChecker typeChecker;

    GetRecordFieldValueEvalFactory$_EvaluatorGen(GetRecordFieldValueEvalFactory$_EvaluatorFactoryGen this$0, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$0 = this$0;
        this.val$ctx = iHyracksTaskContext;
        this.recTypeInfo.reset(GetRecordFieldValueEvalFactory$_EvaluatorFactoryGen.access$200(this.this$0));
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.resultStorage.reset();
            this.fieldNameEval.evaluate(tuple, this.inputArg1);
            if (this.typeChecker.isMissing(this.inputArg1, result)) {
                return;
            }
            byte[] serFldName = this.inputArg1.getByteArray();
            int serFldNameOffset = this.inputArg1.getStartOffset();
            int serFldNameLen = this.inputArg1.getLength();
            this.recordEval.evaluate(tuple, this.inputArg0);
            if (this.typeChecker.isMissing(this.inputArg0, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] serRecord = this.inputArg0.getByteArray();
            int serRecordOffset = this.inputArg0.getStartOffset();
            int serRecordLen = this.inputArg0.getLength();
            if (serRecord[serRecordOffset] != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                throw new TypeMismatchException(GetRecordFieldValueEvalFactory$_EvaluatorFactoryGen.access$300(this.this$0), BuiltinFunctions.GET_RECORD_FIELD_VALUE, (Integer)0, serRecord[serRecordOffset], ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
            }
            int subFieldOffset = -1;
            int subFieldLength = -1;
            int subFieldIndex = this.recTypeInfo.getFieldIndex(serFldName, serFldNameOffset + 1, serFldNameLen - 1);
            if (subFieldIndex >= 0) {
                int nullBitmapSize = RecordUtil.computeNullBitmapSize((ARecordType)GetRecordFieldValueEvalFactory$_EvaluatorFactoryGen.access$200(this.this$0));
                subFieldOffset = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serRecord, (int)serRecordOffset, (int)subFieldIndex, (int)nullBitmapSize, (boolean)GetRecordFieldValueEvalFactory$_EvaluatorFactoryGen.access$200(this.this$0).isOpen());
                if (subFieldOffset == 0) {
                    this.out.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                    result.set((IValueReference)this.resultStorage);
                    return;
                }
                ATypeTag fieldTypeTag = GetRecordFieldValueEvalFactory$_EvaluatorFactoryGen.access$200(this.this$0).getFieldTypes()[subFieldIndex].getTypeTag();
                subFieldLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)subFieldOffset, (ATypeTag)fieldTypeTag, (boolean)false);
                this.out.writeByte(fieldTypeTag.serialize());
                this.out.write(serRecord, subFieldOffset, subFieldLength);
                result.set((IValueReference)this.resultStorage);
                return;
            }
            subFieldOffset = ARecordSerializerDeserializer.getFieldOffsetByName((byte[])serRecord, (int)serRecordOffset, (int)serRecordLen, (byte[])serFldName, (int)serFldNameOffset, (IBinaryHashFunction)this.fieldNameHashFunction, (IBinaryComparator)this.fieldNameComparator);
            if (subFieldOffset < 0) {
                this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                result.set((IValueReference)this.resultStorage);
                return;
            }
            ATypeTag fieldValueTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serRecord[subFieldOffset]);
            subFieldLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serRecord, (int)subFieldOffset, (ATypeTag)fieldValueTypeTag, (boolean)true) + 1;
            result.set(serRecord, subFieldOffset, subFieldLength);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

