/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.CastTypeEvaluator;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

abstract class AbstractRecordAddPutEvaluator
implements IScalarEvaluator {
    private final CastTypeEvaluator inputRecordCaster;
    private final CastTypeEvaluator argRecordCaster;
    private final IScalarEvaluator eval0;
    private final IScalarEvaluator eval1;
    private final IScalarEvaluator eval2;
    final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    final DataOutput resultOutput = this.resultStorage.getDataOutput();
    final IPointable inputRecordPointable = new VoidPointable();
    final UTF8StringPointable newFieldNamePointable = new UTF8StringPointable();
    final IPointable newFieldValuePointable = new VoidPointable();
    final IBinaryComparator stringBinaryComparator = PointableHelper.createStringBinaryComparator();
    final RecordBuilder outRecordBuilder = new RecordBuilder();
    final ARecordVisitablePointable inputOpenRecordPointable;
    boolean newFieldValueIsMissing = false;

    AbstractRecordAddPutEvaluator(IScalarEvaluator eval0, IScalarEvaluator eval1, IScalarEvaluator eval2, IAType[] argTypes) {
        this.eval0 = eval0;
        this.eval1 = eval1;
        this.eval2 = eval2;
        this.inputOpenRecordPointable = new ARecordVisitablePointable(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.inputRecordCaster = new CastTypeEvaluator((IAType)BuiltinType.ANY, argTypes[0], eval0);
        this.argRecordCaster = new CastTypeEvaluator((IAType)BuiltinType.ANY, argTypes[2], eval2);
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.eval0.evaluate(tuple, this.inputRecordPointable);
        this.eval1.evaluate(tuple, (IPointable)this.newFieldNamePointable);
        this.eval2.evaluate(tuple, this.newFieldValuePointable);
        if (this.containsMissing(new IPointable[]{this.inputRecordPointable, this.newFieldNamePointable})) {
            this.writeTypeTag(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
            result.set((IValueReference)this.resultStorage);
            return;
        }
        ATypeTag inputObjectType = PointableHelper.getTypeTag((IValueReference)this.inputRecordPointable);
        ATypeTag newFieldNameValueType = PointableHelper.getTypeTag((IValueReference)this.newFieldNamePointable);
        if (inputObjectType != ATypeTag.OBJECT || newFieldNameValueType != ATypeTag.STRING) {
            PointableHelper.setNull(result);
            return;
        }
        this.inputRecordCaster.evaluate(tuple, this.inputRecordPointable);
        ATypeTag newFieldValueTag = PointableHelper.getTypeTag((IValueReference)this.newFieldValuePointable);
        if (newFieldValueTag.isDerivedType()) {
            this.argRecordCaster.evaluate(tuple, this.newFieldValuePointable);
        }
        this.newFieldValueIsMissing = newFieldValueTag == ATypeTag.MISSING;
        this.buildOutputRecord();
        result.set((IValueReference)this.resultStorage);
    }

    protected abstract void buildOutputRecord() throws HyracksDataException;

    private boolean containsMissing(IPointable ... pointables) {
        for (int i = 0; i < pointables.length; ++i) {
            if (PointableHelper.getTypeTag((IValueReference)pointables[i]) != ATypeTag.MISSING) continue;
            return true;
        }
        return false;
    }

    private void writeTypeTag(byte typeTag) throws HyracksDataException {
        try {
            this.resultOutput.writeByte(typeTag);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

