/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.TreatAsIntegerDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.functions.TreatAsIntegerDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class TreatAsIntegerDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    final /* synthetic */ IScalarEvaluator val$inputEval;
    final /* synthetic */ IPointable val$inputArg;
    final /* synthetic */ ArrayBackedValueStorage val$resultStorage;
    final /* synthetic */ AMutableInt32 val$aInt32;
    final /* synthetic */ ISerializerDeserializer val$int32Ser;
    final /* synthetic */ DataOutput val$out;
    final /* synthetic */ TreatAsIntegerDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker = new TypeChecker();

    TreatAsIntegerDescriptor$_EvaluatorGen(TreatAsIntegerDescriptor$_EvaluatorFactoryGen this$1, IScalarEvaluator iScalarEvaluator, IPointable iPointable, ArrayBackedValueStorage arrayBackedValueStorage, AMutableInt32 aMutableInt32, ISerializerDeserializer iSerializerDeserializer, DataOutput dataOutput) {
        this.this$1 = this$1;
        this.val$inputEval = iScalarEvaluator;
        this.val$inputArg = iPointable;
        this.val$resultStorage = arrayBackedValueStorage;
        this.val$aInt32 = aMutableInt32;
        this.val$int32Ser = iSerializerDeserializer;
        this.val$out = dataOutput;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int intValue;
        this.val$inputEval.evaluate(tuple, this.val$inputArg);
        if (this.typeChecker.isMissing(this.val$inputArg, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        byte[] bytes = this.val$inputArg.getByteArray();
        int startOffset = this.val$inputArg.getStartOffset();
        ATypeTag tt = ATypeTag.VALUE_TYPE_MAPPING[bytes[startOffset]];
        switch (tt) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                intValue = ATypeHierarchy.getIntegerValue((String)this.this$1.this$0.getIdentifier().getName(), (int)0, (byte[])bytes, (int)startOffset, (boolean)true);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                double doubleValue = ATypeHierarchy.getDoubleValue((String)this.this$1.this$0.getIdentifier().getName(), (int)0, (byte[])bytes, (int)startOffset);
                intValue = this.asInt(doubleValue);
                break;
            }
            default: {
                throw new TypeMismatchException(TreatAsIntegerDescriptor$_Gen.access$000(this.this$1.this$0), bytes[startOffset], ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
            }
        }
        this.val$resultStorage.reset();
        this.val$aInt32.setValue(intValue);
        this.val$int32Ser.serialize((Object)this.val$aInt32, this.val$out);
        result.set((IValueReference)this.val$resultStorage);
    }

    private int asInt(double d) throws HyracksDataException {
        long v;
        if (Double.isFinite(d) && (double)(v = (long)d) == d && Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
            return (int)v;
        }
        throw new RuntimeDataException(39, TreatAsIntegerDescriptor$_Gen.access$100(this.this$1.this$0), new Serializable[]{Double.valueOf(d)});
    }
}

