/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.ToNumberDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.functions.ToNumberDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class ToNumberDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    final /* synthetic */ IScalarEvaluator val$inputEval;
    final /* synthetic */ IPointable val$inputArg;
    final /* synthetic */ ArrayBackedValueStorage val$resultStorage;
    final /* synthetic */ AMutableInt64 val$aInt64;
    final /* synthetic */ ISerializerDeserializer val$INT64_SERDE;
    final /* synthetic */ DataOutput val$out;
    final /* synthetic */ UTF8StringPointable val$utf8Ptr;
    final /* synthetic */ AMutableDouble val$aDouble;
    final /* synthetic */ ISerializerDeserializer val$DOUBLE_SERDE;
    final /* synthetic */ ToNumberDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker = new TypeChecker();

    ToNumberDescriptor$_EvaluatorGen(ToNumberDescriptor$_EvaluatorFactoryGen this$1, IScalarEvaluator iScalarEvaluator, IPointable iPointable, ArrayBackedValueStorage arrayBackedValueStorage, AMutableInt64 aMutableInt64, ISerializerDeserializer iSerializerDeserializer, DataOutput dataOutput, UTF8StringPointable uTF8StringPointable, AMutableDouble aMutableDouble, ISerializerDeserializer iSerializerDeserializer2) {
        this.this$1 = this$1;
        this.val$inputEval = iScalarEvaluator;
        this.val$inputArg = iPointable;
        this.val$resultStorage = arrayBackedValueStorage;
        this.val$aInt64 = aMutableInt64;
        this.val$INT64_SERDE = iSerializerDeserializer;
        this.val$out = dataOutput;
        this.val$utf8Ptr = uTF8StringPointable;
        this.val$aDouble = aMutableDouble;
        this.val$DOUBLE_SERDE = iSerializerDeserializer2;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.val$inputEval.evaluate(tuple, this.val$inputArg);
        if (this.typeChecker.isMissing(this.val$inputArg, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        this.val$resultStorage.reset();
        byte[] bytes = this.val$inputArg.getByteArray();
        int startOffset = this.val$inputArg.getStartOffset();
        ATypeTag tt = ATypeTag.VALUE_TYPE_MAPPING[bytes[startOffset]];
        switch (tt) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                result.set((IValueReference)this.val$inputArg);
                break;
            }
            case BOOLEAN: {
                boolean b = ABooleanSerializerDeserializer.getBoolean((byte[])bytes, (int)(startOffset + 1));
                this.val$aInt64.setValue(b ? 1L : 0L);
                this.val$INT64_SERDE.serialize((Object)this.val$aInt64, this.val$out);
                result.set((IValueReference)this.val$resultStorage);
                break;
            }
            case STRING: {
                this.val$utf8Ptr.set(bytes, startOffset + 1, this.val$inputArg.getLength() - 1);
                if (NumberUtils.parseInt64(this.val$utf8Ptr, this.val$aInt64)) {
                    this.val$INT64_SERDE.serialize((Object)this.val$aInt64, this.val$out);
                    result.set((IValueReference)this.val$resultStorage);
                    break;
                }
                if (NumberUtils.parseDouble(this.val$utf8Ptr, this.val$aDouble)) {
                    this.val$DOUBLE_SERDE.serialize((Object)this.val$aDouble, this.val$out);
                    result.set((IValueReference)this.val$resultStorage);
                    break;
                }
                PointableHelper.setNull(result);
                break;
            }
            case ARRAY: 
            case MULTISET: 
            case OBJECT: {
                PointableHelper.setNull(result);
                break;
            }
            default: {
                throw new TypeMismatchException(ToNumberDescriptor$_Gen.access$000(this.this$1.this$0), this.this$1.this$0.getIdentifier(), (Integer)0, bytes[startOffset], ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG, ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG, ATypeTag.SERIALIZED_STRING_TYPE_TAG, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
            }
        }
    }
}

