/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AUnorderedListSerializerDeserializer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.evaluators.constructors.AbstractBooleanConstructorEvaluator$_EvaluatorGen;
import org.apache.asterix.runtime.evaluators.functions.ToBooleanDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.util.string.UTF8StringUtil;

class ToBooleanDescriptor$_EvaluatorGen
extends AbstractBooleanConstructorEvaluator$_EvaluatorGen {
    final /* synthetic */ ToBooleanDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    ToBooleanDescriptor$_EvaluatorGen(ToBooleanDescriptor$_EvaluatorFactoryGen this$1, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        this.this$1 = this$1;
        super(inputEval, sourceLoc);
        this.typeChecker = new TypeChecker();
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        byte[] bytes = this.inputArg.getByteArray();
        int offset = this.inputArg.getStartOffset();
        ATypeTag tt = ATypeTag.VALUE_TYPE_MAPPING[bytes[offset]];
        switch (tt) {
            case TINYINT: {
                this.setInteger(AInt8SerializerDeserializer.getByte((byte[])bytes, (int)(offset + 1)), result);
                break;
            }
            case SMALLINT: {
                this.setInteger(AInt16SerializerDeserializer.getShort((byte[])bytes, (int)(offset + 1)), result);
                break;
            }
            case INTEGER: {
                this.setInteger(AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(offset + 1)), result);
                break;
            }
            case BIGINT: {
                this.setInteger(AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(offset + 1)), result);
                break;
            }
            case FLOAT: {
                this.setDouble(AFloatSerializerDeserializer.getFloat((byte[])bytes, (int)(offset + 1)), result);
                break;
            }
            case DOUBLE: {
                this.setDouble(ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1)), result);
                break;
            }
            case STRING: {
                this.setInteger(UTF8StringUtil.getStringLength((byte[])bytes, (int)(offset + 1)), result);
                break;
            }
            case ARRAY: {
                this.setInteger(AOrderedListSerializerDeserializer.getNumberOfItems((byte[])bytes, (int)offset), result);
                break;
            }
            case MULTISET: {
                this.setInteger(AUnorderedListSerializerDeserializer.getNumberOfItems((byte[])bytes, (int)offset), result);
                break;
            }
            case OBJECT: {
                this.setBoolean(result, !ARecordSerializerDeserializer.hasNoFields((byte[])bytes, (int)offset, (int)this.inputArg.getLength()));
                break;
            }
            default: {
                super.evaluateImpl(result);
            }
        }
    }

    private void setInteger(long v, IPointable result) throws HyracksDataException {
        this.setBoolean(result, v != 0L);
    }

    private void setDouble(double v, IPointable result) throws HyracksDataException {
        long bits = Double.doubleToLongBits(v);
        boolean zeroOrNaN = bits == NumberUtils.POSITIVE_ZERO_BITS || bits == NumberUtils.NEGATIVE_ZERO_BITS || bits == NumberUtils.NAN_BITS;
        this.setBoolean(result, !zeroOrNaN);
    }

    @Override
    protected FunctionIdentifier getIdentifier() {
        return this.this$1.this$0.getIdentifier();
    }
}

