/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class SubstringBeforeDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new SubstringBeforeDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable array0 = new VoidPointable();
                    private IPointable array1 = new VoidPointable();
                    private IScalarEvaluator evalString;
                    private IScalarEvaluator evalPattern;
                    private final GrowableArray array;
                    private final UTF8StringBuilder builder;
                    private final UTF8StringPointable stringPtr;
                    private final UTF8StringPointable patternPtr;
                    {
                        this.evalString = args[0].createScalarEvaluator(ctx);
                        this.evalPattern = args[1].createScalarEvaluator(ctx);
                        this.array = new GrowableArray();
                        this.builder = new UTF8StringBuilder();
                        this.stringPtr = new UTF8StringPointable();
                        this.patternPtr = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.evalString.evaluate(tuple, this.array0);
                        byte[] src = this.array0.getByteArray();
                        int srcOffset = this.array0.getStartOffset();
                        int srcLen = this.array0.getLength();
                        this.evalPattern.evaluate(tuple, this.array1);
                        byte[] pattern = this.array1.getByteArray();
                        int patternOffset = this.array1.getStartOffset();
                        int patternLen = this.array1.getLength();
                        if (src[srcOffset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                            throw new TypeMismatchException(SubstringBeforeDescriptor.this.sourceLoc, SubstringBeforeDescriptor.this.getIdentifier(), (Integer)0, src[srcOffset], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                        }
                        if (pattern[patternOffset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                            throw new TypeMismatchException(SubstringBeforeDescriptor.this.sourceLoc, SubstringBeforeDescriptor.this.getIdentifier(), (Integer)1, pattern[patternOffset], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                        }
                        try {
                            this.stringPtr.set(src, srcOffset + 1, srcLen - 1);
                            this.patternPtr.set(pattern, patternOffset + 1, patternLen - 1);
                            this.array.reset();
                            UTF8StringPointable.substrBefore((UTF8StringPointable)this.stringPtr, (UTF8StringPointable)this.patternPtr, (UTF8StringBuilder)this.builder, (GrowableArray)this.array);
                            this.out.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            this.out.write(this.array.getByteArray(), 0, this.array.getLength());
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.SUBSTRING_BEFORE;
    }
}

