/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.AbstractQuadStringStringEval;
import org.apache.asterix.runtime.evaluators.functions.utils.RegExpMatcher;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public class StringRegExpReplaceWithFlagDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new StringRegExpReplaceWithFlagDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                return new AbstractQuadStringStringEval(ctx, args[0], args[1], args[2], args[3], StringRegExpReplaceWithFlagDescriptor.this.getIdentifier(), StringRegExpReplaceWithFlagDescriptor.this.sourceLoc){
                    private final UTF8StringPointable emptyFlags;
                    private final RegExpMatcher matcher;
                    private int limit;
                    {
                        this.emptyFlags = UTF8StringPointable.generateUTF8Pointable((String)"");
                        this.matcher = new RegExpMatcher();
                    }

                    @Override
                    protected void processArgument(int argIdx, IPointable argPtr, UTF8StringPointable outStrPtr) throws HyracksDataException {
                        if (argIdx == 3) {
                            byte[] bytes = argPtr.getByteArray();
                            int start = argPtr.getStartOffset();
                            ATypeTag tt = ATypeTag.VALUE_TYPE_MAPPING[bytes[start]];
                            switch (tt) {
                                case TINYINT: 
                                case SMALLINT: 
                                case INTEGER: 
                                case BIGINT: {
                                    this.limit = ATypeHierarchy.getIntegerValue((String)this.funcID.getName(), (int)argIdx, (byte[])bytes, (int)start, (boolean)true);
                                    outStrPtr.set((IValueReference)this.emptyFlags);
                                    return;
                                }
                            }
                            this.limit = Integer.MAX_VALUE;
                        }
                        super.processArgument(argIdx, argPtr, outStrPtr);
                    }

                    @Override
                    protected String compute(UTF8StringPointable srcPtr, UTF8StringPointable patternPtr, UTF8StringPointable replacePtr, UTF8StringPointable flagsPtr) throws IOException {
                        this.matcher.build(srcPtr, patternPtr, flagsPtr);
                        return this.matcher.replace(replacePtr, this.limit);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.STRING_REGEXP_REPLACE_WITH_FLAG;
    }
}

