/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.runtime.evaluators.functions.AbstractBinaryStringIntEval;
import org.apache.asterix.runtime.evaluators.functions.AbstractStringOffsetConfigurableDescriptor;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public class StringPositionDescriptor
extends AbstractStringOffsetConfigurableDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new StringPositionDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_STRING_OFFSET;
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;
            private final int baseOffset;
            {
                this.baseOffset = StringPositionDescriptor.this.stringOffset;
            }

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                return new AbstractBinaryStringIntEval(ctx, args[0], args[1], StringPositionDescriptor.this.getIdentifier(), StringPositionDescriptor.this.sourceLoc){

                    @Override
                    protected int compute(UTF8StringPointable left, UTF8StringPointable right) throws IOException {
                        int pos = UTF8StringPointable.find((UTF8StringPointable)left, (UTF8StringPointable)right, (boolean)false);
                        return pos < 0 ? pos : pos + baseOffset;
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.STRING_POSITION;
    }
}

