/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.functions.StringLengthDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.functions.StringLengthDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

class StringLengthDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private AMutableInt64 result = new AMutableInt64(0L);
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    private IPointable inputArg = new VoidPointable();
    private IScalarEvaluator eval;
    private ISerializerDeserializer<AInt64> int64Serde;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ StringLengthDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    StringLengthDescriptor$_EvaluatorGen(StringLengthDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable resultPointable) throws HyracksDataException {
        try {
            int offset;
            this.resultStorage.reset();
            this.eval.evaluate(tuple, this.inputArg);
            if (this.typeChecker.isMissing(this.inputArg, resultPointable)) {
                return;
            }
            if (this.typeChecker.isNull(resultPointable)) {
                return;
            }
            byte[] serString = this.inputArg.getByteArray();
            if (serString[offset = this.inputArg.getStartOffset()] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                throw new TypeMismatchException(StringLengthDescriptor$_Gen.access$000(this.this$1.this$0), this.this$1.this$0.getIdentifier(), (Integer)0, serString[offset], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            }
            int len = UTF8StringUtil.getUTFLength((byte[])serString, (int)(offset + 1));
            this.result.setValue((long)len);
            this.int64Serde.serialize((Object)this.result, this.out);
            resultPointable.set((IValueReference)this.resultStorage);
        }
        catch (IOException e1) {
            throw HyracksDataException.create((Throwable)e1);
        }
    }
}

