/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class StringJoinDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new StringJoinDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final ListAccessor listAccessor = new ListAccessor();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IScalarEvaluatorFactory listEvalFactory;
                    private final IScalarEvaluatorFactory sepEvalFactory;
                    private final IPointable inputArgList;
                    private final IPointable inputArgSep;
                    private final IScalarEvaluator evalList;
                    private final IScalarEvaluator evalSep;
                    private ISerializerDeserializer<ANull> nullSerde;
                    private ISerializerDeserializer<AMissing> missingSerde;
                    private final byte[] tempLengthArray;
                    {
                        this.listEvalFactory = args[0];
                        this.sepEvalFactory = args[1];
                        this.inputArgList = new VoidPointable();
                        this.inputArgSep = new VoidPointable();
                        this.evalList = this.listEvalFactory.createScalarEvaluator(ctx);
                        this.evalSep = this.sepEvalFactory.createScalarEvaluator(ctx);
                        this.nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
                        this.missingSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AMISSING);
                        this.tempLengthArray = new byte[5];
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        int sepOffset;
                        this.resultStorage.reset();
                        this.evalList.evaluate(tuple, this.inputArgList);
                        this.evalSep.evaluate(tuple, this.inputArgSep);
                        byte[] listBytes = this.inputArgList.getByteArray();
                        int listOffset = this.inputArgList.getStartOffset();
                        if (listBytes[listOffset] != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG && listBytes[listOffset] != ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                            throw new TypeMismatchException(StringJoinDescriptor.this.sourceLoc, StringJoinDescriptor.this.getIdentifier(), (Integer)0, listBytes[listOffset], ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG);
                        }
                        byte[] sepBytes = this.inputArgSep.getByteArray();
                        if (sepBytes[sepOffset = this.inputArgSep.getStartOffset()] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                            throw new TypeMismatchException(StringJoinDescriptor.this.sourceLoc, StringJoinDescriptor.this.getIdentifier(), (Integer)1, sepBytes[sepOffset], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                        }
                        int sepLen = UTF8StringUtil.getUTFLength((byte[])sepBytes, (int)(sepOffset + 1));
                        int sepMetaLen = UTF8StringUtil.getNumBytesToStoreLength((int)sepLen);
                        this.listAccessor.reset(listBytes, listOffset);
                        try {
                            int utf8Len = 0;
                            int size = this.listAccessor.size();
                            for (int i = 0; i < size; ++i) {
                                int itemOffset = this.listAccessor.getItemOffset(i);
                                ATypeTag itemType = this.listAccessor.getItemType(itemOffset);
                                if (this.listAccessor.itemsAreSelfDescribing()) {
                                    ++itemOffset;
                                }
                                if (itemType != ATypeTag.STRING) {
                                    if (itemType == ATypeTag.NULL) {
                                        this.nullSerde.serialize((Object)ANull.NULL, this.out);
                                        result.set((IValueReference)this.resultStorage);
                                        return;
                                    }
                                    if (itemType == ATypeTag.MISSING) {
                                        this.missingSerde.serialize((Object)AMissing.MISSING, this.out);
                                        result.set((IValueReference)this.resultStorage);
                                        return;
                                    }
                                    throw new UnsupportedItemTypeException(StringJoinDescriptor.this.sourceLoc, StringJoinDescriptor.this.getIdentifier(), itemType.serialize());
                                }
                                int currentSize = UTF8StringUtil.getUTFLength((byte[])listBytes, (int)itemOffset);
                                if (i != size - 1 && currentSize != 0) {
                                    utf8Len += sepLen;
                                }
                                utf8Len += currentSize;
                            }
                            this.out.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            int cbytes = UTF8StringUtil.encodeUTF8Length((int)utf8Len, (byte[])this.tempLengthArray, (int)0);
                            this.out.write(this.tempLengthArray, 0, cbytes);
                            for (int i = 0; i < this.listAccessor.size(); ++i) {
                                int itemOffset = this.listAccessor.getItemOffset(i);
                                if (this.listAccessor.itemsAreSelfDescribing()) {
                                    ++itemOffset;
                                }
                                utf8Len = UTF8StringUtil.getUTFLength((byte[])listBytes, (int)itemOffset);
                                this.out.write(listBytes, UTF8StringUtil.getNumBytesToStoreLength((int)utf8Len) + itemOffset, utf8Len);
                                for (int j = 0; j < sepLen; ++j) {
                                    this.out.writeByte(sepBytes[sepOffset + 1 + sepMetaLen + j]);
                                }
                            }
                        }
                        catch (IOException ex) {
                            throw HyracksDataException.create((Throwable)ex);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.STRING_JOIN;
    }
}

