/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class OrDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new OrDescriptor();
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.OR;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                VoidPointable argPtr = new VoidPointable();
                final IScalarEvaluator[] evals = new IScalarEvaluator[args.length];
                for (int i = 0; i < evals.length; ++i) {
                    evals[i] = args[i].createScalarEvaluator(ctx);
                }
                return new IScalarEvaluator((IPointable)argPtr){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput output = this.resultStorage.getDataOutput();
                    private ISerializerDeserializer<ABoolean> booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
                    private ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
                    private ISerializerDeserializer<AMissing> missingSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AMISSING);
                    final /* synthetic */ IPointable val$argPtr;
                    {
                        this.val$argPtr = iPointable;
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        int n = args.length;
                        boolean res = false;
                        boolean metNull = false;
                        boolean metMissing = false;
                        for (int i = 0; i < n; ++i) {
                            evals[i].evaluate(tuple, this.val$argPtr);
                            byte[] data = this.val$argPtr.getByteArray();
                            int offset = this.val$argPtr.getStartOffset();
                            if (data[offset] == ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                                metMissing = true;
                                continue;
                            }
                            if (data[offset] == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
                                metNull = true;
                                continue;
                            }
                            if (data[offset] != ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG) {
                                throw new TypeMismatchException(OrDescriptor.this.sourceLoc, OrDescriptor.this.getIdentifier(), (Integer)i, data[offset], ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG);
                            }
                            boolean argResult = ABooleanSerializerDeserializer.getBoolean((byte[])data, (int)(offset + 1));
                            if (argResult) {
                                this.booleanSerde.serialize((Object)ABoolean.TRUE, this.output);
                                result.set((IValueReference)this.resultStorage);
                                return;
                            }
                            res |= argResult;
                        }
                        if (metNull) {
                            this.nullSerde.serialize((Object)ANull.NULL, this.output);
                        } else if (metMissing) {
                            this.missingSerde.serialize((Object)AMissing.MISSING, this.output);
                        } else {
                            ABoolean aResult = res ? ABoolean.TRUE : ABoolean.FALSE;
                            this.booleanSerde.serialize((Object)aResult, this.output);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }
}

