/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.functions.AbstractNumericArithmeticEval$_Gen;
import org.apache.asterix.runtime.evaluators.functions.NumericDivDescriptor$_InnerGen;
import org.apache.asterix.runtime.exceptions.OverflowException;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class NumericDivDescriptor$_Gen
extends AbstractNumericArithmeticEval$_Gen {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new NumericDivDescriptor$_InnerGen();

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.NUMERIC_DIV;
    }

    @Override
    protected boolean evaluateDouble(double lhs, double rhs, AMutableDouble result) {
        if (rhs == 0.0) {
            return false;
        }
        double res = lhs / rhs;
        result.setValue(res);
        return true;
    }

    @Override
    protected boolean evaluateInteger(long lhs, long rhs, AMutableInt64 result) throws HyracksDataException {
        if (rhs == 0L) {
            return false;
        }
        if (lhs == Long.MIN_VALUE && rhs == -1L) {
            throw new OverflowException(this.sourceLoc, this.getIdentifier());
        }
        long res = lhs / rhs;
        result.setValue(res);
        return true;
    }

    @Override
    protected boolean evaluateTimeDurationArithmetic(long chronon, int yearMonth, long dayTime, boolean isTimeOnly, AMutableInt64 result) {
        throw new NotImplementedException("Divide operation is not defined for temporal types");
    }

    @Override
    protected boolean evaluateTimeInstanceArithmetic(long chronon0, long chronon1, AMutableInt64 result) throws HyracksDataException {
        throw new UnsupportedTypeException(this.sourceLoc, this.getIdentifier(), ATypeTag.SERIALIZED_TIME_TYPE_TAG);
    }
}

