/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.temporal.DurationArithmeticOperations;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.functions.AbstractNumericArithmeticEval$_Gen;
import org.apache.asterix.runtime.evaluators.functions.NumericAddDescriptor$_InnerGen;
import org.apache.asterix.runtime.exceptions.OverflowException;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class NumericAddDescriptor$_Gen
extends AbstractNumericArithmeticEval$_Gen {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new NumericAddDescriptor$_InnerGen();

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.NUMERIC_ADD;
    }

    @Override
    protected boolean evaluateInteger(long x, long y, AMutableInt64 result) throws HyracksDataException {
        try {
            long res = Math.addExact(x, y);
            result.setValue(res);
            return true;
        }
        catch (ArithmeticException e) {
            throw new OverflowException(this.sourceLoc, this.getIdentifier());
        }
    }

    @Override
    protected boolean evaluateDouble(double lhs, double rhs, AMutableDouble result) throws HyracksDataException {
        double res = lhs + rhs;
        result.setValue(res);
        return true;
    }

    @Override
    protected boolean evaluateTimeDurationArithmetic(long chronon, int yearMonth, long dayTime, boolean isTimeOnly, AMutableInt64 result) throws HyracksDataException {
        long res = DurationArithmeticOperations.addDuration((long)chronon, (int)yearMonth, (long)dayTime, (boolean)isTimeOnly);
        result.setValue(res);
        return true;
    }

    @Override
    protected boolean evaluateTimeInstanceArithmetic(long chronon0, long chronon1, AMutableInt64 result) throws HyracksDataException {
        throw new UnsupportedTypeException(this.sourceLoc, this.getIdentifier(), ATypeTag.SERIALIZED_TIME_TYPE_TAG);
    }
}

