/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.AbstractUnaryNumericFunctionEval;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;

public class NumericAbsDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new NumericAbsDescriptor();
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.NUMERIC_ABS;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                return new NumericAbsEvaluator(ctx, args[0]);
            }
        };
    }

    private class NumericAbsEvaluator
    extends AbstractUnaryNumericFunctionEval {
        NumericAbsEvaluator(IHyracksTaskContext context, IScalarEvaluatorFactory argEvalFactory) throws HyracksDataException {
            super(context, argEvalFactory, NumericAbsDescriptor.this.getIdentifier(), NumericAbsDescriptor.this.sourceLoc);
        }

        @Override
        protected void processInt8(byte arg, IPointable resultPointable) throws HyracksDataException {
            if (arg >= 0) {
                resultPointable.set((IValueReference)this.argPtr);
                return;
            }
            this.aInt8.setValue((byte)(0 - arg));
            this.serialize((IAObject)this.aInt8, this.int8Serde, resultPointable);
        }

        @Override
        protected void processInt16(short arg, IPointable resultPointable) throws HyracksDataException {
            if (arg >= 0) {
                resultPointable.set((IValueReference)this.argPtr);
                return;
            }
            this.aInt16.setValue((short)(0 - arg));
            this.serialize((IAObject)this.aInt16, this.int16Serde, resultPointable);
        }

        @Override
        protected void processInt32(int arg, IPointable resultPointable) throws HyracksDataException {
            if (arg >= 0) {
                resultPointable.set((IValueReference)this.argPtr);
                return;
            }
            this.aInt32.setValue(0 - arg);
            this.serialize((IAObject)this.aInt32, this.int32Serde, resultPointable);
        }

        @Override
        protected void processInt64(long arg, IPointable resultPointable) throws HyracksDataException {
            if (arg >= 0L) {
                resultPointable.set((IValueReference)this.argPtr);
                return;
            }
            this.aInt64.setValue(0L - arg);
            this.serialize((IAObject)this.aInt64, this.int64Serde, resultPointable);
        }

        @Override
        protected void processFloat(float arg, IPointable resultPointable) throws HyracksDataException {
            if (arg >= 0.0f) {
                resultPointable.set((IValueReference)this.argPtr);
                return;
            }
            this.aFloat.setValue(0.0f - arg);
            this.serialize((IAObject)this.aFloat, this.floatSerde, resultPointable);
        }

        @Override
        protected void processDouble(double arg, IPointable resultPointable) throws HyracksDataException {
            if (arg >= 0.0) {
                resultPointable.set((IValueReference)this.argPtr);
                return;
            }
            this.aDouble.setValue(0.0 - arg);
            this.serialize((IAObject)this.aDouble, this.doubleSerde, resultPointable);
        }
    }
}

