/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class NumericATan2Descriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new NumericATan2Descriptor();
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.NUMERIC_ATAN2;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final IPointable leftPtr = new VoidPointable();
                    private final IPointable rightPtr = new VoidPointable();
                    private final IScalarEvaluator evalLeft;
                    private final IScalarEvaluator evalRight;
                    private final double[] operands;
                    private final AMutableDouble aDouble;
                    private final ISerializerDeserializer outputSerde;
                    private final ArrayBackedValueStorage resultStorage;
                    private final DataOutput out;
                    {
                        this.evalLeft = args[0].createScalarEvaluator(ctx);
                        this.evalRight = args[1].createScalarEvaluator(ctx);
                        this.operands = new double[args.length];
                        this.aDouble = new AMutableDouble(0.0);
                        this.outputSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
                        this.resultStorage = new ArrayBackedValueStorage();
                        this.out = this.resultStorage.getDataOutput();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.evalLeft.evaluate(tuple, this.leftPtr);
                        this.evalRight.evaluate(tuple, this.rightPtr);
                        for (int i = 0; i < args.length; ++i) {
                            IPointable argPtr = i == 0 ? this.leftPtr : this.rightPtr;
                            byte[] data = argPtr.getByteArray();
                            int offset = argPtr.getStartOffset();
                            this.operands[i] = ATypeHierarchy.getDoubleValue((String)NumericATan2Descriptor.this.getIdentifier().getName(), (int)i, (byte[])data, (int)offset);
                        }
                        this.aDouble.setValue(Math.atan2(this.operands[0], this.operands[1]));
                        this.outputSerde.serialize((Object)this.aDouble, this.out);
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }
}

