/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.NumericATan2Descriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class NumericATan2Descriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final IPointable leftPtr = new VoidPointable();
    private final IPointable rightPtr = new VoidPointable();
    private final IScalarEvaluator evalLeft;
    private final IScalarEvaluator evalRight;
    private final double[] operands;
    private final AMutableDouble aDouble;
    private final ISerializerDeserializer outputSerde;
    private final ArrayBackedValueStorage resultStorage;
    private final DataOutput out;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ NumericATan2Descriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    NumericATan2Descriptor$_EvaluatorGen(NumericATan2Descriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.evalLeft = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.evalRight = this.this$1.val$args[1].createScalarEvaluator(this.val$ctx);
        this.operands = new double[this.this$1.val$args.length];
        this.aDouble = new AMutableDouble(0.0);
        this.outputSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
        this.resultStorage = new ArrayBackedValueStorage();
        this.out = this.resultStorage.getDataOutput();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.evalLeft.evaluate(tuple, this.leftPtr);
        if (this.typeChecker.isMissing(this.leftPtr, result)) {
            return;
        }
        this.evalRight.evaluate(tuple, this.rightPtr);
        if (this.typeChecker.isMissing(this.rightPtr, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        for (int i = 0; i < this.this$1.val$args.length; ++i) {
            IPointable argPtr = i == 0 ? this.leftPtr : this.rightPtr;
            byte[] data = argPtr.getByteArray();
            int offset = argPtr.getStartOffset();
            this.operands[i] = ATypeHierarchy.getDoubleValue((String)this.this$1.this$0.getIdentifier().getName(), (int)i, (byte[])data, (int)offset);
        }
        this.aDouble.setValue(Math.atan2(this.operands[0], this.operands[1]));
        this.outputSerde.serialize((Object)this.aDouble, this.out);
        result.set((IValueReference)this.resultStorage);
    }
}

