/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.FloatPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class IfNanOrInfDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = IfNanOrInfDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                return new AbstractIfInfOrNanEval(ctx, args){

                    @Override
                    protected boolean skipDouble(double d) {
                        return Double.isInfinite(d) || Double.isNaN(d);
                    }

                    @Override
                    protected boolean skipFloat(float f) {
                        return Float.isInfinite(f) || Float.isNaN(f);
                    }

                    @Override
                    protected FunctionIdentifier getIdentifier() {
                        return IfNanOrInfDescriptor.this.getIdentifier();
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.IF_NAN_OR_INF;
    }

    public static abstract class AbstractIfInfOrNanEval
    implements IScalarEvaluator {
        private final IScalarEvaluator[] argEvals;
        private final IPointable argPtr;

        AbstractIfInfOrNanEval(IHyracksTaskContext ctx, IScalarEvaluatorFactory[] args) throws HyracksDataException {
            this.argEvals = new IScalarEvaluator[args.length];
            for (int i = 0; i < this.argEvals.length; ++i) {
                this.argEvals[i] = args[i].createScalarEvaluator(ctx);
            }
            this.argPtr = new VoidPointable();
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            block5: for (int i = 0; i < this.argEvals.length; ++i) {
                this.argEvals[i].evaluate(tuple, this.argPtr);
                ATypeTag argTypeTag = PointableHelper.getTypeTag((IValueReference)this.argPtr);
                if (argTypeTag == null) {
                    throw new RuntimeDataException(6, new Serializable[]{this.getIdentifier(), Integer.valueOf(i)});
                }
                switch (argTypeTag) {
                    case DOUBLE: {
                        double d = DoublePointable.getDouble((byte[])this.argPtr.getByteArray(), (int)(this.argPtr.getStartOffset() + 1));
                        if (this.skipDouble(d)) continue block5;
                        result.set((IValueReference)this.argPtr);
                        return;
                    }
                    case FLOAT: {
                        float f = FloatPointable.getFloat((byte[])this.argPtr.getByteArray(), (int)(this.argPtr.getStartOffset() + 1));
                        if (this.skipFloat(f)) continue block5;
                        result.set((IValueReference)this.argPtr);
                        return;
                    }
                    case BIGINT: 
                    case INTEGER: 
                    case SMALLINT: 
                    case TINYINT: 
                    case MISSING: {
                        result.set((IValueReference)this.argPtr);
                        return;
                    }
                    default: {
                        PointableHelper.setNull(result);
                        return;
                    }
                }
            }
            PointableHelper.setNull(result);
        }

        protected abstract FunctionIdentifier getIdentifier();

        protected abstract boolean skipDouble(double var1);

        protected abstract boolean skipFloat(float var1);
    }
}

