/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AUnorderedListSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.evaluators.functions.GetItemDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.functions.GetItemDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class GetItemDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput output = this.resultStorage.getDataOutput();
    private IPointable inputArgList = new VoidPointable();
    private IPointable inputArgIdx = new VoidPointable();
    private IScalarEvaluator evalList = GetItemDescriptor$_EvaluatorFactoryGen.access$000(this.this$1).createScalarEvaluator(this.val$ctx);
    private IScalarEvaluator evalIdx = GetItemDescriptor$_EvaluatorFactoryGen.access$100(this.this$1).createScalarEvaluator(this.val$ctx);
    private byte[] missingBytes = new byte[]{ATypeTag.SERIALIZED_MISSING_TYPE_TAG};
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ GetItemDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker = new TypeChecker();

    GetItemDescriptor$_EvaluatorGen(GetItemDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            int itemOffset;
            int itemCount;
            this.evalList.evaluate(tuple, this.inputArgList);
            if (this.typeChecker.isMissing(this.inputArgList, result)) {
                return;
            }
            this.evalIdx.evaluate(tuple, this.inputArgIdx);
            if (this.typeChecker.isMissing(this.inputArgIdx, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] serList = this.inputArgList.getByteArray();
            int offset = this.inputArgList.getStartOffset();
            byte[] indexBytes = this.inputArgIdx.getByteArray();
            int indexOffset = this.inputArgIdx.getStartOffset();
            byte serListTypeTag = serList[offset];
            if (serListTypeTag == ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
                itemCount = AOrderedListSerializerDeserializer.getNumberOfItems((byte[])serList, (int)offset);
            } else if (serListTypeTag == ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                itemCount = AUnorderedListSerializerDeserializer.getNumberOfItems((byte[])serList, (int)offset);
            } else {
                throw new TypeMismatchException(GetItemDescriptor$_Gen.access$200(this.this$1.this$0), BuiltinFunctions.GET_ITEM, (Integer)0, serListTypeTag, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG);
            }
            int itemIndex = ATypeHierarchy.getIntegerValue((String)BuiltinFunctions.GET_ITEM.getName(), (int)0, (byte[])indexBytes, (int)indexOffset);
            if (itemIndex < 0 || itemIndex >= itemCount) {
                result.set(this.missingBytes, 0, 1);
                return;
            }
            byte serItemTypeTag = serList[offset + 1];
            ATypeTag itemTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serItemTypeTag);
            boolean selfDescList = itemTag == ATypeTag.ANY;
            int n = itemOffset = serListTypeTag == ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG ? AOrderedListSerializerDeserializer.getItemOffset((byte[])serList, (int)offset, (int)itemIndex) : AUnorderedListSerializerDeserializer.getItemOffset((byte[])serList, (int)offset, (int)0);
            if (selfDescList) {
                itemTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serList[itemOffset]);
                int itemLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serList, (int)itemOffset, (ATypeTag)itemTag, (boolean)true) + 1;
                result.set(serList, itemOffset, itemLength);
            } else {
                int itemLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serList, (int)itemOffset, (ATypeTag)itemTag, (boolean)false);
                this.resultStorage.reset();
                this.output.writeByte(serItemTypeTag);
                this.output.write(serList, itemOffset, itemLength);
                result.set((IValueReference)this.resultStorage);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

