/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import org.apache.asterix.builders.ArrayListFactory;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.dataflow.data.nontagged.comparators.AObjectAscBinaryComparatorFactory;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.runtime.evaluators.functions.AbstractArrayProcessArraysEval;
import org.apache.asterix.runtime.evaluators.functions.ArrayUnionDescriptor$_Gen;
import org.apache.asterix.runtime.utils.ArrayFunctionsUtil;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;

public class ArrayUnionDescriptor$_InnerGen1
extends AbstractArrayProcessArraysEval {
    private final IObjectPool<List<IPointable>, ATypeTag> pointableListAllocator;
    private final IBinaryHashFunction binaryHashFunction;
    private final Int2ObjectMap<List<IPointable>> hashes;
    private final IBinaryComparator comp;
    final /* synthetic */ ArrayUnionDescriptor$_Gen this$0;

    public ArrayUnionDescriptor$_InnerGen1(ArrayUnionDescriptor$_Gen this$0, IScalarEvaluatorFactory[] args, IHyracksTaskContext ctx) throws HyracksDataException {
        this.this$0 = this$0;
        super(args, ctx, true, ArrayUnionDescriptor$_Gen.access$000(this$0), ArrayUnionDescriptor$_Gen.access$100(this$0));
        this.pointableListAllocator = new ListObjectPool((IObjectFactory)new ArrayListFactory());
        this.hashes = new Int2ObjectOpenHashMap();
        this.comp = AObjectAscBinaryComparatorFactory.INSTANCE.createBinaryComparator();
        this.binaryHashFunction = BinaryHashFunctionFactoryProvider.INSTANCE.getBinaryHashFunctionFactory(null).createBinaryHashFunction();
    }

    @Override
    protected void init() {
        this.hashes.clear();
    }

    @Override
    protected void finish(IAsterixListBuilder listBuilder) {
    }

    @Override
    protected void release() {
        this.pointableListAllocator.reset();
    }

    @Override
    protected boolean processItem(IPointable item, int listIndex, IAsterixListBuilder listBuilder) throws HyracksDataException {
        int hash = this.binaryHashFunction.hash(item.getByteArray(), item.getStartOffset(), item.getLength());
        List sameHashes = (List)this.hashes.get(hash);
        if (sameHashes == null) {
            sameHashes = (List)this.pointableListAllocator.allocate(null);
            sameHashes.clear();
            this.addItem(listBuilder, item, sameHashes);
            this.hashes.put(hash, (Object)sameHashes);
            return true;
        }
        if (ArrayFunctionsUtil.findItem((IValueReference)item, sameHashes, this.comp) == null) {
            this.addItem(listBuilder, item, sameHashes);
            return true;
        }
        return false;
    }

    private void addItem(IAsterixListBuilder listBuilder, IPointable item, List<IPointable> sameHashes) throws HyracksDataException {
        listBuilder.addItem((IValueReference)item);
        sameHashes.add(item);
    }
}

