/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import org.apache.asterix.builders.ArrayListFactory;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.dataflow.data.nontagged.comparators.AObjectAscBinaryComparatorFactory;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.runtime.evaluators.functions.AbstractArrayProcessArraysEval$_EvaluatorGen;
import org.apache.asterix.runtime.evaluators.functions.ArraySymDiffEval$_InnerGen;
import org.apache.asterix.runtime.evaluators.functions.ArraySymDiffEval$_InnerGen1;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.utils.ArrayFunctionsUtil;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.common.arraylist.IntArrayList;

public class ArraySymDiffEval$_EvaluatorGen
extends AbstractArrayProcessArraysEval$_EvaluatorGen {
    private final IBinaryHashFunction binaryHashFunction;
    private final Int2ObjectMap<List<ArraySymDiffEval$_InnerGen>> hashes;
    private final IObjectPool<List<ArraySymDiffEval$_InnerGen>, ATypeTag> arrayListAllocator = new ListObjectPool((IObjectFactory)new ArrayListFactory());
    private final IObjectPool<ArraySymDiffEval$_InnerGen, ATypeTag> valueCounterAllocator = new ListObjectPool((IObjectFactory)new ArraySymDiffEval$_InnerGen1(this));
    private final IBinaryComparator comp;
    private final IntArrayList intHashes;
    private final TypeChecker typeChecker;

    public ArraySymDiffEval$_EvaluatorGen(IScalarEvaluatorFactory[] args, IHyracksTaskContext ctx, SourceLocation sourceLocation, IAType[] argTypes) throws HyracksDataException {
        super(args, ctx, true, sourceLocation, argTypes);
        this.hashes = new Int2ObjectOpenHashMap();
        this.comp = AObjectAscBinaryComparatorFactory.INSTANCE.createBinaryComparator();
        this.intHashes = new IntArrayList(50, 10);
        this.binaryHashFunction = BinaryHashFunctionFactoryProvider.INSTANCE.getBinaryHashFunctionFactory(null).createBinaryHashFunction();
        this.typeChecker = new TypeChecker();
    }

    @Override
    protected void init() {
        this.hashes.clear();
        this.intHashes.clear();
    }

    @Override
    protected void finish(IAsterixListBuilder listBuilder) throws HyracksDataException {
        for (int i = 0; i < this.intHashes.size(); ++i) {
            List items = (List)this.hashes.get(this.intHashes.get(i));
            for (int k = 0; k < items.size(); ++k) {
                ArraySymDiffEval$_InnerGen item = (ArraySymDiffEval$_InnerGen)items.get(k);
                if (!this.checkCounter(ArraySymDiffEval$_InnerGen.access$000(item))) continue;
                listBuilder.addItem((IValueReference)ArraySymDiffEval$_InnerGen.access$100(item));
            }
        }
    }

    @Override
    protected void release() {
        this.arrayListAllocator.reset();
        this.valueCounterAllocator.reset();
    }

    protected boolean checkCounter(int counter) {
        return counter == 1;
    }

    @Override
    protected boolean processItem(IPointable item, int listIndex, IAsterixListBuilder listBuilder) throws HyracksDataException {
        int hash = this.binaryHashFunction.hash(item.getByteArray(), item.getStartOffset(), item.getLength());
        List sameHashes = (List)this.hashes.get(hash);
        if (sameHashes == null) {
            sameHashes = (List)this.arrayListAllocator.allocate(null);
            sameHashes.clear();
            this.addItem(item, listIndex, sameHashes);
            this.hashes.put(hash, (Object)sameHashes);
            this.intHashes.add(hash);
            return true;
        }
        ArraySymDiffEval$_InnerGen itemListIdxCounter = (ArraySymDiffEval$_InnerGen)ArrayFunctionsUtil.findItem((IValueReference)item, sameHashes, this.comp);
        if (itemListIdxCounter == null) {
            this.addItem(item, listIndex, sameHashes);
            return true;
        }
        if (ArraySymDiffEval$_InnerGen.access$200(itemListIdxCounter) != listIndex) {
            ArraySymDiffEval$_InnerGen.access$202(itemListIdxCounter, listIndex);
            ArraySymDiffEval$_InnerGen.access$008(itemListIdxCounter);
        }
        return false;
    }

    private void addItem(IPointable item, int listIndex, List<ArraySymDiffEval$_InnerGen> sameHashes) {
        ArraySymDiffEval$_InnerGen valueCounter = (ArraySymDiffEval$_InnerGen)this.valueCounterAllocator.allocate(null);
        valueCounter.reset(item, listIndex, 1);
        sameHashes.add(valueCounter);
    }
}

