/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.asterix.builders.ArrayListFactory;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.ArrayStarDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.functions.ArrayStarDescriptor$_InnerGen;
import org.apache.asterix.runtime.evaluators.functions.ArrayStarDescriptor$_InnerGen1;
import org.apache.asterix.runtime.evaluators.functions.ArrayStarDescriptor$_InnerGen2;
import org.apache.asterix.runtime.evaluators.functions.CastTypeEvaluator;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ArrayStarDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final IBinaryComparator binaryStrComp = PointableHelper.createStringBinaryComparator();
    private final ArrayStarDescriptor$_InnerGen comp = new ArrayStarDescriptor$_InnerGen(this.this$0);
    private final ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
    private final IScalarEvaluator listEval;
    private final IPointable list;
    private final IPointable tempList;
    private final IPointable object = new VoidPointable();
    private final CastTypeEvaluator caster;
    private final ListAccessor listAccessor;
    private final RecordBuilder recordBuilder;
    private final IAsterixListBuilder listBuilder;
    private final PointableAllocator pointableAllocator;
    private final List<ArrayStarDescriptor$_InnerGen1> fieldNameToValuesList;
    private final PriorityQueue<ArrayStarDescriptor$_InnerGen1> tempMinHeap;
    private final IObjectPool<List<IVisitablePointable>, ATypeTag> arrayListAllocator;
    private final IObjectPool<ArrayStarDescriptor$_InnerGen1, ATypeTag> fieldNameToValuesAllocator;
    final /* synthetic */ ArrayStarDescriptor$_Gen this$0;
    private final TypeChecker typeChecker;

    public ArrayStarDescriptor$_EvaluatorGen(ArrayStarDescriptor$_Gen this$0, IScalarEvaluatorFactory[] args, IHyracksTaskContext ctx) throws HyracksDataException {
        this.this$0 = this$0;
        this.list = new VoidPointable();
        this.tempList = new VoidPointable();
        this.listEval = args[0].createScalarEvaluator(ctx);
        this.caster = new CastTypeEvaluator();
        this.listAccessor = new ListAccessor();
        this.recordBuilder = new RecordBuilder();
        this.listBuilder = new OrderedListBuilder();
        this.pointableAllocator = new PointableAllocator();
        this.fieldNameToValuesList = new ArrayList<ArrayStarDescriptor$_InnerGen1>();
        this.tempMinHeap = new PriorityQueue<IValueReference>(this.comp);
        this.arrayListAllocator = new ListObjectPool((IObjectFactory)new ArrayListFactory());
        this.fieldNameToValuesAllocator = new ListObjectPool((IObjectFactory)new ArrayStarDescriptor$_InnerGen2(this$0));
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.storage.reset();
        this.listEval.evaluate(tuple, this.tempList);
        if (this.typeChecker.isMissing(this.tempList, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        ATypeTag listTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.tempList.getByteArray()[this.tempList.getStartOffset()]);
        if (listTag != ATypeTag.ARRAY) {
            PointableHelper.setNull(result);
            return;
        }
        try {
            this.caster.resetAndAllocate((IAType)DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE, ArrayStarDescriptor$_Gen.access$000(this.this$0), this.listEval);
            this.caster.cast(this.tempList, this.list);
            this.tempMinHeap.clear();
            this.fieldNameToValuesList.clear();
            this.listAccessor.reset(this.list.getByteArray(), this.list.getStartOffset());
            int numObjects = this.listAccessor.size();
            for (int objectIndex = 0; objectIndex < numObjects; ++objectIndex) {
                this.listAccessor.getOrWriteItem(objectIndex, this.object, this.storage);
                this.processObject(this.object, objectIndex, numObjects);
            }
            if (this.fieldNameToValuesList.isEmpty()) {
                PointableHelper.setMissing(result);
                return;
            }
            for (int i = 0; i < this.fieldNameToValuesList.size(); ++i) {
                this.tempMinHeap.add(this.fieldNameToValuesList.get(i));
            }
            this.recordBuilder.reset(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
            this.recordBuilder.init();
            while (!this.tempMinHeap.isEmpty()) {
                ArrayStarDescriptor$_InnerGen1 fieldNameToValues = this.tempMinHeap.poll();
                this.listBuilder.reset((AbstractCollectionType)DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE);
                for (int k = 0; k < ArrayStarDescriptor$_InnerGen1.access$100(fieldNameToValues).size(); ++k) {
                    IVisitablePointable oneValue = (IVisitablePointable)ArrayStarDescriptor$_InnerGen1.access$100(fieldNameToValues).get(k);
                    if (oneValue == null) {
                        this.listBuilder.addItem((IValueReference)PointableHelper.NULL_REF);
                        continue;
                    }
                    this.listBuilder.addItem((IValueReference)oneValue);
                }
                this.storage.reset();
                this.listBuilder.write(this.storage.getDataOutput(), true);
                this.recordBuilder.addField((IValueReference)ArrayStarDescriptor$_InnerGen1.access$200(fieldNameToValues), (IValueReference)this.storage);
            }
            this.storage.reset();
            this.recordBuilder.write(this.storage.getDataOutput(), true);
            result.set((IValueReference)this.storage);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            this.pointableAllocator.reset();
            this.arrayListAllocator.reset();
            this.fieldNameToValuesAllocator.reset();
            this.caster.deallocatePointables();
        }
    }

    private void processObject(IPointable object, int objectIndex, int numObjects) throws HyracksDataException {
        if (object.getByteArray()[object.getStartOffset()] == ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
            ARecordVisitablePointable record = this.pointableAllocator.allocateRecordValue((IAType)DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
            record.set(object.getByteArray(), object.getStartOffset(), object.getLength());
            List fieldNames = record.getFieldNames();
            List fieldValues = record.getFieldValues();
            for (int j = 0; j < fieldNames.size(); ++j) {
                List values;
                IVisitablePointable fieldName = (IVisitablePointable)fieldNames.get(j);
                ArrayStarDescriptor$_InnerGen1 fieldNameToValues = this.findField(fieldName, this.fieldNameToValuesList, this.binaryStrComp);
                if (fieldNameToValues == null) {
                    fieldNameToValues = (ArrayStarDescriptor$_InnerGen1)this.fieldNameToValuesAllocator.allocate(null);
                    values = (List)this.arrayListAllocator.allocate(null);
                    this.clear(values, numObjects);
                    ArrayStarDescriptor$_InnerGen1.access$202(fieldNameToValues, fieldName);
                    ArrayStarDescriptor$_InnerGen1.access$102(fieldNameToValues, values);
                    this.fieldNameToValuesList.add(fieldNameToValues);
                } else {
                    values = ArrayStarDescriptor$_InnerGen1.access$100(fieldNameToValues);
                }
                values.set(objectIndex, fieldValues.get(j));
            }
        }
    }

    private void clear(List<IVisitablePointable> values, int numObjects) {
        values.clear();
        for (int i = 1; i <= numObjects; ++i) {
            values.add(null);
        }
    }

    private ArrayStarDescriptor$_InnerGen1 findField(IVisitablePointable fieldName, List<ArrayStarDescriptor$_InnerGen1> fieldNamesList, IBinaryComparator strComp) throws HyracksDataException {
        for (int i = 0; i < fieldNamesList.size(); ++i) {
            ArrayStarDescriptor$_InnerGen1 anotherFieldName = fieldNamesList.get(i);
            if (!PointableHelper.isEqual((IValueReference)fieldName, (IValueReference)ArrayStarDescriptor$_InnerGen1.access$200(anotherFieldName), strComp)) continue;
            return anotherFieldName;
        }
        return null;
    }
}

